﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Model.Entities.Files;
using Model.Entities.Files.FS_Entities;
using Model.Entities.Users;
using Model.UnitsOfWork;


namespace BLL.Services.System
{
    /// <summary>
    /// Сервис проверки прав пользователя на основе групп
    /// </summary>
    public class PermissionServices : Base.BaseServices
    {
        public PermissionServices(UOW UOW) : base(UOW) { }

        /// <summary>
        /// Метод получает права на папку для пользователя
        /// на основе того, к каким группам он относиться
        /// </summary>
        /// <param name="user"></param>
        /// <param name="rootDirectory"></param>
        /// <returns></returns>
        protected Permission GetPermissionForRootDirectory(User user, SRootDirectory rootDirectory)
        {
            IEnumerable<Group> groups;

            if (user != null)
            {
                groups = user.Groups.ToArray();
            }
            else
            {
                groups = new List<Group>() { UOW.Repo_Group.GetDefaultGroup(EnumDefaultGroups.Анонимные) };
            }

            

            if (groups.FirstOrDefault(e => 
            e.Name == EnumDefaultGroups.Администраторы.ToString()) != null)
                return new Permission()
                {
                    DirectoryID = rootDirectory.ID,
                    RootDirectory = rootDirectory,
                    CanDownload = true,
                    CanUpload = true,
                    CanOpen = true
                };


            Permission res = new Permission()
            {
                DirectoryID = rootDirectory.ID,
                RootDirectory = rootDirectory,
                CanDownload = false,
                CanUpload = false,
                CanOpen = false
            };

            foreach (var elem in groups)
            {
                var dir_permission = elem.DirectoryPermissions.
                    Permissions[rootDirectory.ID];


                if (!res.CanDownload && dir_permission.CanDownload)
                    res.CanDownload = true;
                if (!res.CanOpen && dir_permission.CanOpen)
                    res.CanOpen = true;
                if (!res.CanUpload && dir_permission.CanUpload)
                    res.CanUpload = true;
            }

            return res;
        }
        public Permission GetPermissionForDirectory(User user, SDirectory directory)
        {
            if (directory.IsRoot)
                return GetPermissionForRootDirectory(user, (SRootDirectory)directory);
            else
                return GetPermissionForRootDirectory(user, directory.Root);
        }

        public bool CanDownload(User user, SDirectory directory)
        {
            return GetPermissionForDirectory(user, directory).CanDownload;
        }

        public bool CanUpload(User user, SDirectory directory)
        {
            return GetPermissionForDirectory(user, directory).CanUpload;
        }

        public bool CanOpen(User user, SDirectory directory)
        {
            return GetPermissionForDirectory(user, directory).CanOpen;
        }

    }
}
