﻿
import React from 'react';
import { Button, InputGroup, FormControl, ProgressBar, Card, Table } from 'react-bootstrap'

import Notification from '../../../Tools/Notification'

import UploadServices from '../../../Services/UploadServices'

import BaseControl from '../../BaseControl.jsx'


export default class UploaderControl extends BaseControl {

    constructor(props) {
        super(props, "UploaderControl");  

        //state 0 - выбор файла
        //state 1 - загрузка
        this.state = {
            progress: 0,
            UploadedSize: 0,
            ButtonUploadEnable: true, _state: 0,
            FileInfo: {},
            ResultMsg: ""
        };


        this.uploadServices = new UploadServices();
        this.uploadServices.OnProggresseChange = this.OnProgresseChange;
        //this.uploadServices.OnIDReceived = null;
        this.uploadServices.OnError = this.OnError;
    }

    UploadClick() {

        let input = this.refs.file;
        let files = input.files;


        if (files.length == 0)
            return;
        let file = files[0];

        this.setState({ ButtonUploadEnable: false, _state: 1, FileInfo: { name: file.name, size: file.size } });

        this.uploadServices.UploadFileAsync(
            file,
            this.GlobalState.MainExplorer.ID
        ).then(function () {
            Notification.MesOk('Complete','Upload');

            this.setState({ ButtonUploadEnable: true, _state: 0, FileInfo: {}, ResultMsg: "" });
            this.EventRegister.EventAction(this.GlobalState.MainExplorer.ChangeEvent);
            input.value = "";
        }.bind(this));
    }

    CancelClick() {
        this.uploadServices.Cansel();
        this.setState({ ButtonUploadEnable: true, _state: 0, FileInfo: {} });
    }

    OnProgresseChange(Process, size) {
        this.setState({
            progress: Process,
            UploadedSize: size
        });
    }

    OnError(Msg) {
        this.setState({ progress: 0, ButtonUploadEnable: true, _state: 0, FileInfo: {}, ResultMsg: Msg });
    }



    render() {
        return (
            <div>
                <h3>Загрузка файлов</h3>

                <InputGroup>
                    <FormControl ref="file" type="file" disabled={!this.state.ButtonUploadEnable}/>
                    <InputGroup.Append>
                        <Button disabled={!this.state.ButtonUploadEnable} onClick={this.UploadClick} variant="outline-success">Загрузить</Button>
                        <Button disabled={this.state.ButtonUploadEnable} onClick={this.CancelClick} variant="outline-danger">Отмена</Button>
                    </InputGroup.Append>
                </InputGroup>

                {this.state._state == 1
                    ?
                    <div>
                        <Card>                            
                            <Card.Body>
                                <Card.Title>Выполняется загрука файлов</Card.Title>
                                <Table bordered size="sm">
                                    <thead>
                                        <tr>
                                            <th>Имя</th>
                                            <th>Размер</th>
                                            <th>Прогресс</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{this.state.FileInfo.name}</td>
                                            <td>{this.state.FileInfo.size}</td>
                                            <td>
                                                <ProgressBar now={this.state.progress} label={`${this.state.progress}%`} />
                                                {this.state.UploadedSize}
                                            </td>
                                        </tr>
                                    </tbody>
                                </Table>
                            </Card.Body>
                        </Card>
                    </div>
                    : ""
                }

                {this.state.ResultMsg != ""
                    ? <p>Результат: {this.state.ResultMsg}</p>
                    : null
                }

            </div>
        );
    }
}