﻿
import React from 'react';
import { Nav } from 'react-bootstrap'

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'
import UserDetailControl from '../Controls/User/UserDetailControl.jsx'


export default class UserPage extends BaseControl {

    constructor(props) {
        super(props, "UserPage");

        this.authServices = new AuthServices();
        this.state = {
            isAuth: this.authServices.IsAuth()
        };        

        this.EventRegister.RegisterListener("OnAuthChange", this);
    }

    Event_OnAuthChange() {
        this.setState({ isAuth: this.authServices.IsAuth() });
    }

    render() {
        return (
            <div>
                {this.state.isAuth
                    ?
                    <div>
                        <UserDetailControl />
                    </div>
                    : <p>Вы не авторизованы</p>
                }
            </div>
        );
    }
}

