﻿
import React from 'react';
import { Link } from 'react-router-dom';
import { Nav, Navbar, NavDropdown, MenuItem, NavItem } from 'react-bootstrap'

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'


export default class MenuControl extends BaseControl {

    constructor(props) {
        super(props, "MenuControl");

        this.authServices = new AuthServices();
        this.state = {
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User != undefined
                ? this.GlobalState.User.IsAdmin
                : false
        };

        this.EventRegister.RegisterListener("OnAuthChange", this);
    }

    Event_OnAuthChange() {
        this.setState({
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User.IsAdmin
        });
    }

    render() {

        return (
            <Navbar>
                {/* "Link" in brand component since just redirect is needed */}
                <Navbar.Brand>WebFileServer</Navbar.Brand>
                <Nav>
                    {/* "NavLink" here since "active" class styling is needed */}
                    <Nav.Link as={Link} to='/'>App</Nav.Link>

                    {this.state.IsAuth
                        ?
                        <Nav>
                            <Nav.Link as={Link} to='/User'>User</Nav.Link>

                            {this.state.IsAdmin
                                ?
                                <Nav.Link as={Link} to='/Admin'>Admin</Nav.Link>
                                : null}
                        </Nav>
                        : null}
                </Nav>
            </Navbar>
        );
    }
}

