﻿
import React from 'react';
import { Form } from 'react-bootstrap'

import Notification from '../../../Tools/Notification'

import AuthServices from '../../../Services/AuthServices'

import BaseControl from '../../BaseControl.jsx'



export default class UserControl extends BaseControl {

    constructor(props) {
        super(props, "UserControl");

        this.authServices = new AuthServices();
        this.state = {
            IsAuth: this.authServices.IsAuth(),
            CurrentUser: this.GlobalState.User != undefined
                ? this.GlobalState.User
                : this.UserInfo(null)
        };

        if (this.authServices.IsAuth())
            this.authServices.GetUserInfoAsync().then(function (data) {

                if (data.Successe) {
                    this.GlobalState.User = this.UserInfo(data.User);
                }
                else {
                    this.GlobalState.User = this.UserInfo(null);                   

                    Notification.MesEr(data.ResMessage, "Auth");
                }

                this.setState ({
                    IsAuth: this.authServices.IsAuth(),
                    CurrentUser: this.GlobalState.User
                });
                this.EventRegister.EventAction("OnAuthChange");

            }.bind(this));
    }

    UserInfo(user) {
        if (user == null)
            return {
                Login: "",
                IsAdmin: false
            };

        return {
            Login: user.Login,
            IsAdmin: user.IsAdmin
        };
    }

    //Кнопка входа
    AuthClick() {
        let login = this.refs.Login.value;
        let password = this.refs.Password.value;

        this.authServices.AuthAsync(login, password)
            .then(function (data) {

                if (data.Successe) {
                    this.GlobalState.User = this.UserInfo(data.User);
                }
                else {
                    this.GlobalState.User = this.UserInfo(null);

                    Notification.MesEr(data.ResMessage, "Auth");
                }

                this.setState({
                    IsAuth: this.authServices.IsAuth(),
                    CurrentUser: this.GlobalState.User
                });
                this.EventRegister.EventAction("OnAuthChange");

            }.bind(this));
    }

    //Кнопка выхода
    LogoutClick() {
        this.authServices.Logout();
        this.GlobalState.User = this.UserInfo(null);

        this.setState({
            IsAuth: this.authServices.IsAuth(),
            CurrentUser: this.GlobalState.User
        });
        this.EventRegister.EventAction("OnAuthChange");
    }


    render() {
        return (
            <div>
                {this.state.IsAuth
                    ?
                    <div>
                        <p>Вы авторизованы. Пользователь: {this.state.CurrentUser.Login}.</p>
                        {this.state.CurrentUser.IsAdmin
                            ? <p>Вы администратор</p>
                            : null
                        }

                        <button onClick={this.LogoutClick}>Logout</button>
                    </div>
                    :
                    <div>
                        <p>Вы не авторизованы. Вход:</p>

                        {/*<Form.Label>Email address</Form.Label>*/}
                        <Form.Control ref="Login" type="text" placeholder="Enter login" />
                        <Form.Text className="text-muted">
                            We'll never share your login with anyone else.
                        </Form.Text>
                        <br />
                        {/*<Form.Label>Password</Form.Label>*/}
                        <Form.Control ref="Password" type="password" placeholder="Password" />
                        <br />
                        <button onClick={this.AuthClick}>Auth</button>
                    </div>
                }
            </div>
        );
    }
}

