﻿
import ApiQuery from '../Tools/ApiQuery'


export default class UserServices {

    constructor() {
        this.URL_GetUsers = "api/Users/GetUserList";
        this.URL_SetUsers = "api/Users/SetUserList";

        this.URL_GetGroups = "api/Users/GetGroupList";
        this.URL_SetGroups = "api/Users/SetGroupList";

        this.URL_GetRootDirs = "api/Users/GetRootDirList";
        this.URL_SetRootDirs = "api/Users/SetRootDirList";

        //AutodecrementID
        this.ID = 0;
    }


    async GetUsersAsync() {
        return await ApiQuery(this.URL_GetUsers, "Post")
            .then(function (data) {
                if (data.Successe) {
                    this.Groups = data.Groups;
                }

                return data;
            }.bind(this));
    }
    async SetUsersAsync(users) {

        return await ApiQuery(this.URL_SetUsers, "Post", users);
    }


    CreateUser() {
        this.ID--;

        return {
            ID: this.ID,
            Name: "NewUser" + this.ID,
            Password: "QWERTY",
            Active: true,
            Changes: 2, //Create

            Groups: this.Groups.map((e) => {
                return {
                    ID: e.ID,
                    Name: e.Name,
                    EnterInGroup: (e.Name == "Пользователи") ? true : false
                };
            })
        };
    }
    CreateStubUser() {
        return {
            ID: -1,
            Name: "",
            Password: "",
            Active: false,
            Changes: -1,
            Groups: [{
                ID: -11,
                Name: "",
                EnterInGroup: false
            }]
        }
    }



    async GetGroupsAsync() {
        return await ApiQuery(this.URL_GetGroups, "Post")
            .then(function (data) {
                if (data.Successe) {
                    this.RootDirs = data.RootDirs;
                }

                return data;
            }.bind(this));
    }
    async SetGroupsAsync(groups) {

        return await ApiQuery(this.URL_SetGroups, "Post", groups)
            .then(function (data) {
                return data;
            }.bind(this));
    }


    CreateGroup() {
        this.ID--;

        return {
            ID: this.ID,
            Name: "NewGroup" + this.ID,
            Changes: 2, //Create

            RootDirs: this.RootDirs.map((e) => {
                return {
                    ID: e.ID,
                    Name: e.Name,
                    CanDownload: false,
                    CanUpload: false,
                    CanOpen: false
                };
            })
        };
    }
    CreateStubGroup() {
        return {
            ID: this.ID,
            Name: "NewGroup" + this.ID,
            Changes: 2, //Create

            RootDirs: [{
                ID: -11,
                Name: "",
                CanDownload: false,
                CanUpload: false,
                CanOpen: false
            }]
        }
    }



    async GetRootDirsAsync() {
        return await ApiQuery(this.URL_GetRootDirs, "Post")
            .then(function (data) {
                if (data.Successe) {
                    this.RootDirs = data.RootDirs;
                }

                return data;
            }.bind(this));
    }
    async SetRootDirsAsync(RootDirs) {

        return await ApiQuery(this.URL_SetRootDirs, "Post", RootDirs)
            .then(function (data) {
                return data;
            }.bind(this));
    }


    CreateRootDir() {
        this.ID--;

        return {
            ID: this.ID,
            Name: "NewRootDir" + this.ID,
            Changes: 2, //Create            
        };
    }

}
