﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.Threading.Tasks;
using System.Text;
using System.Data.Entity;

using Model.Entities.Users;
using Model.ViewModel.Edit;
using Web.Models.Base;
using BLL.Services.FS;
using BLL.Services.Mapper;


namespace Web.Controllers.API.Admin
{

    public class UsersController : Base.BaseApiController
    {
        readonly ScanServices ScanServices;

        readonly UserMapper UserMapper;
        readonly GroupMapper GroupMapper;
        readonly RootDirsMapper RootDirsMapper;

        public UsersController()
        {
            ScanServices = new ScanServices(UOW);

            UserMapper = new UserMapper(UOW, permissionServices);
            GroupMapper = new GroupMapper(UOW, permissionServices);
            RootDirsMapper = new RootDirsMapper(UOW, permissionServices, () => Server.MapPath("~/App_Data"));
        }

        [HttpPost]
        public JsonResult GetUserList()
        {
            UserListMode json;

            if (CurrentUser != null && CurrentUser.IsAdmin)
            {
                json = new UserListMode(true)
                {
                    Users = UserMapper.GetEdit_User(),
                    Groups = GroupMapper.GetInfo_Group()
                };
            }
            else
            {
                json = new UserListMode(false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                };
            }

            return Json(json);
        }
        [HttpPost]
        public JsonResult SetUserList(List<EditUserModel> model)
        {
            if (!CurrentUser.IsAdmin)
                return Json(new BaseApiResult(false, "", ""));

            StringBuilder res = new StringBuilder();
            bool HaveErr = false;

            var Users = UserMapper.GetEntities_User(model);

            foreach (var elem in Users)
            {
                try
                {
                    switch (elem.Edited.Changes)
                    {
                        case EnumChanges.Create:
                            UOW.Repo_User.Create(elem.DBUser);

                            res.Append(elem.Edited.Name + "|Cr|");
                            break;
                        case EnumChanges.Update:
                            UOW.Repo_User.Update(elem.DBUser);

                            res.Append(elem.Edited.Name + "|Up|");
                            break;
                        case EnumChanges.Delete:
                            UOW.Repo_User.Delete(elem.DBUser);

                            res.Append(elem.Edited.Name + "|De|");
                            break;
                    }
                }
                catch (Exception ex)
                {
                    res.Append(elem.Edited.Name + "|Error|" + ex.Message);
                    HaveErr = true;
                }
            }

            return Json(new BaseApiResult(!HaveErr, res.ToString(), "SetUserList"));
        }

        public class UserListMode : BaseApiResult
        {
            public UserListMode(bool Successe) : base(Successe, "", "UserList") { }

            public List<EditUserModel> Users;
            public List<InfoGroupModel> Groups;
        }



        [HttpPost]
        public JsonResult GetGroupList()
        {
            GroupListMode json;

            if (CurrentUser != null && CurrentUser.IsAdmin)
            {
                json = new GroupListMode(true)
                {
                    Groups = GroupMapper.GetEdit_Group(),
                    RootDirs = RootDirsMapper.GetInfo_RootDir()
                };

            }
            else
            {
                json = new GroupListMode(false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                };
            }

            return Json(json);
        }
        [HttpPost]
        public JsonResult SetGroupList(List<EditGroupModel> model)
        {
            if (!CurrentUser.IsAdmin)
                return Json(new BaseApiResult(false, "", ""));

            StringBuilder res = new StringBuilder();
            bool HaveErr = false;

            var Groups = GroupMapper.GetEntities_Group(model);

            foreach (var elem in Groups)
            {
                try
                {
                    switch (elem.Edited.Changes)
                    {
                        case EnumChanges.Create:
                            UOW.Repo_Group.Create(elem.DB);

                            res.Append(elem.Edited.Name + "|Cr|");
                            break;
                        case EnumChanges.Update:
                            UOW.Repo_Group.Update(elem.DB);

                            res.Append(elem.Edited.Name + "|Up|");
                            break;
                        case EnumChanges.Delete:
                            UOW.Repo_Group.Delete(elem.DB);

                            res.Append(elem.Edited.Name + "|De|");
                            break;
                    }
                }
                catch (Exception ex)
                {
                    res.Append(elem.Edited.Name + "|Error|" + ex.Message);
                    HaveErr = true;
                }
            }

            return Json(new BaseApiResult(!HaveErr, res.ToString(), "SetGroupList"));
        }

        public class GroupListMode : BaseApiResult
        {
            public GroupListMode(bool Successe) : base(Successe, "", "GroupList") { }

            public List<EditGroupModel> Groups;
            public List<InfoRootDirModel> RootDirs;
        }



        [HttpPost]
        public JsonResult GetRootDirList()
        {
            RootDirsListMode json;

            if (CurrentUser != null && CurrentUser.IsAdmin)
            {
                json = new RootDirsListMode(true)
                {
                    Dirs = RootDirsMapper.GetEdit_Group()
                };
            }
            else
            {
                json = new RootDirsListMode(false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                };
            }

            return Json(json);
        }
        [HttpPost]
        public async Task<JsonResult> SetRootDirList(List<EditRootDirModel> model)
        {
            if (!CurrentUser.IsAdmin)
                return Json(new BaseApiResult(false, "", ""));

            StringBuilder res = new StringBuilder();
            bool HaveErr = false;

            var Groups = RootDirsMapper.GetEntities_RootDir(model);

            foreach (var elem in Groups)
            {
                try
                {
                    switch (elem.Edited.Changes)
                    {
                        case EnumChanges.Create:
                            UOW.Repo_SRootDirectory.Create(elem.DB);
                            await ScanServices.RecursScanDirectoryAsync(elem.DB, true);

                            res.Append(elem.Edited.Name + "|Cr|");
                            break;
                        case EnumChanges.Update:
                            UOW.Repo_SRootDirectory.Update(elem.DB);

                            res.Append(elem.Edited.Name + "|Up|");
                            break;
                        case EnumChanges.Delete:
                            UOW.Repo_SRootDirectory.DeleteInList(elem.DB);

                            res.Append(elem.Edited.Name + "|De|");
                            break;
                    }
                }
                catch (Exception ex)
                {
                    res.Append(elem.Edited.Name + "|Error|" + ex.Message);
                    HaveErr = true;
                }
            }

            return Json(new BaseApiResult(!HaveErr, res.ToString(), "SetRootDirList"));
        }

        public class RootDirsListMode : BaseApiResult
        {
            public RootDirsListMode(bool Successe) : base(Successe, "", "RootDirsList") { }

            public List<EditRootDirModel> Dirs;
        }

    }
}