﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Web.Mvc;
using System.Web.Script.Serialization;

using Web.Controllers.Base;

namespace Web.Models.Base
{
    public class BaseApiResult
    {
        [ScriptIgnore]
        private BaseController controller;

        public bool Successe { set; get; }
        public string ResMessage { set; get; }
        public string ActionName { set; get; }


        public bool PermissionError { set; get; }

        [ScriptIgnore]
        public JsonResult ToJson => controller.ToJson(this);


        public BaseApiResult(BaseController controller, bool Successe, string ResMessage)
        {
            this.controller = controller;
            this.Successe = Successe;
            this.ResMessage = ResMessage;

            ActionName = controller.ActionName;
        }
    }
}