﻿
import React from 'react';
import { Link } from 'react-router-dom';
import { Button, Form } from 'react-bootstrap' 

import BaseControl from '../../BaseControl.jsx'
import Configuration from '../../../Tools/Configuration'
import FileExplorerServices from '../../../Services/FileExplorerServices'

import Notification from '../../../Tools/Notification'

import ImageFileFind from '../../../../Images/file-find.png'


export default class FileExplorerRow extends BaseControl {

    constructor(props) {
        super(props, "FileExplorerRow");

        this.state = {
            Data: this.props.data,
            ShoSelectColumn: this.props.ShoSelectColumn
        };

        this.fileExplorerServices = new FileExplorerServices();
    }

    componentWillReceiveProps(nextProps) {
        this.props = nextProps;

        if (this.refs.Select != undefined)
            this.refs.Select.checked = false;

        this.setState({
            Data: this.props.data,
            ShoSelectColumn: this.props.ShoSelectColumn
        });

        //Log("FileExplorerRow " + this.props.ID, "GetDataID: " + this.GetDataID());
    }

    GetDirectory() {
        return this.GlobalState[this.props.CurrentDirectoryName];
    }

    GetData() {
        return this.state.Data;
    }

    GetDataID() {
        return this.state.Data.ID;
    }
    IsCheked() {
        if (this.refs.Select == undefined)
            return false;

        return this.refs.Select.checked;
    }


    OnDirectoryClick() {
        this.GetDirectory().ID = this.GetDataID();
        this.EventRegister.EventAction(this.GetDirectory().ChangeEvent);
    }

    OnPreviewClick(sender) {
        let id = sender.target.attributes[0].value;
        let extension = sender.target.attributes[1].value;
        //  Service это функция открытия определенного расширения по указанной ссылке
        let Service =
            Configuration
                .OpenRegisteredExtension
                .find(item => item.Ext.includes(extension))
                .Service;

        this
            .fileExplorerServices
            .CreateTmpLink(id)
            .then(
                function (data) {

                    if (!data.Successe)
                    {
                        Notification.MesEr_Hide(data.ResMessage, 'Ошибка генерация одноразовой ссылки');
                        return;
                    }
                    
                    Service(window.location.origin + '/api/Explorer/GetFileOneLink/' + data.Key);
                }
                .bind(this)
            );

    }

    render() {
        let state = this.state;
        let elem = state.Data;

        return (
            <tr>
                {
                    (Configuration.EnviromentValue == 'Development')
                        ?
                        <td>{elem.ID}</td>
                        : null
                }
                {state.ShoSelectColumn
                    ?
                    <td>
                        <Form.Check ref="Select"/>                       
                    </td>
                    : null
                }


                {(elem.Type === "RootDirectory" || elem.Type === "Directory")
                    ?
                    <td>
                        <Link to={`/?ID=${elem.ID}`}>
                            <Button id={elem.ID} onClick={this.OnDirectoryClick} variant="light">
                                {elem.Name}
                            </Button>
                        </Link>
                    </td>
                    :
                    (Configuration.RegisteredExtension.includes(elem.FileExtension))
                        ?
                        <td>
                            <div style={{ position: 'relative'}}>
                                <p style={{ float: 'left', marginBottom: 0, marginTop: '.5rem' }}>{elem.Name}</p>
                                <Button elemid={elem.ID} elemext={elem.FileExtension} onClick={this.OnPreviewClick} variant="light" style={{ padding: '.375rem', float: 'right' }}>
                                    <img elemid={elem.ID} elemext={elem.FileExtension} src={ImageFileFind} width="24" height="24" />
                                </Button>
                            </div>
                        </td>
                        :
                        <td>{elem.Name}</td>

                    
                }
                <td>{elem.Type}</td>
                <td>{elem.FileExtension}</td>

                {elem.Size !== -1
                    ? <td>{elem.Size}</td>
                    : <td></td>
                }
            </tr>
        );
    }
}