﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Diagnostics;

using NodeStarterTools.SolutionPaths;
using NodeStarterTools.BuildWorker;

namespace NodeStarterTools
{
    /// <summary>
    /// dev or build
    /// if (build) copy bundle to mvc
    /// </summary>
    class Program
    {
        static readonly Config Config = new Config();

        
        /// <summary>
        /// Запускает webpack dev server
        /// </summary>
        static void Debug(bool RunFromVSBuild)
        {
            //Запущен при старте либо при сборке
            if (!RunFromVSBuild)
            {
                Console.WriteLine("Run from debug VS");

                //Проверка, что webpack dev server уже запущен
                switch (Config.DebugDevMode)
                {
                    case EnumDevMode.NoCheckExists:
                        Console.WriteLine("EnumDevMode.NoCheckExists");

                        new DebugWorker(Config).Work();
                        break;

                    case EnumDevMode.IfExistsNoRun:
                        Console.WriteLine("EnumDevMode.NoCheckExists");

                        if (Process.GetProcesses().
                            Where(e => e.MainWindowTitle == "npm").
                            Count() == 0)
                            new DebugWorker(Config).Work();
                        break;

                    case EnumDevMode.IfExistsReload:
                        Console.WriteLine("EnumDevMode.IfExistsReload");

                        Process.GetProcesses().
                            Where(e => e.MainWindowTitle == "npm").
                            ToList().ForEach(e => e.CloseMainWindow());
                        new DebugWorker(Config).Work();
                        break;
                }


            }
            //запущена при сборке
            else
            {
                Console.WriteLine("Run from debug build");
            }
        }

        /// <summary>
        /// Запускает сборку бандла
        /// </summary>
        static void Release(bool RunFromVSBuild)
        {
            if (!RunFromVSBuild)
            {
                Console.WriteLine("Run from release VS");
                //Не требуется так как сработает событие окончания сборки
                //Release();
            }
            else
            {
                Console.WriteLine("Run from release build");
                new ReleaseWorker(Config).Work();
            }
        }


        static void Main(string[] args)
        {
            if (!Config.RunSPA)
                return;

            //true - запущен при сборке из VS
            bool RunFromVSBuild = args.Length != 0;

#if DEBUG
            Debug(RunFromVSBuild);
#else
            Release(RunFromVSBuild);         
#endif

        }
    }
}
