﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Diagnostics;
using System.IO;

using NodeStarterTools.SolutionPaths;

namespace NodeStarterTools.BuildWorker
{
    public class ReleaseWorker : BaseWorker
    {
        public ReleaseWorker(Config Config) 
            : base(Config)
        { }


        /// <summary>
        /// 1) очищаем папки для сборки в проекта (SPA, WEB)
        /// 2) Запускаем сбоку через Node webpack (через bat файл)
        /// 3) Результат сборки копируется в Asp.MVC Web приложение
        /// </summary>
        public override void Work()
        {
            PathExplorer pathExplorer = new PathExplorer();
            Console.WriteLine("Run SPA build");

            //Clear build dirs
            pathExplorer.RecreateDirs(new List<string>()
            {
                Config.SPAProjectBuild.FullName,
                Config.WebProjectSPA.FullName
            });

            ProcessStartInfo build = new ProcessStartInfo()
            {
                FileName = Config.SPAProject.FullName + @"\build.bat",
                WorkingDirectory = Config.SPAProject.FullName,
                CreateNoWindow = false,
                WindowStyle = ProcessWindowStyle.Normal
            };
            Process.Start(build).WaitForExit();


            //Копирование
            var spa_files = Config.SPAProjectBuild.GetFiles("*", SearchOption.AllDirectories);

            foreach (var elem in spa_files)
            {
                string src_path = elem.FullName;
                string dst_path = pathExplorer
                    .GetReleativePath(elem.FullName, Config.SPAProjectBuild.Name, Config.WebProjectSPA.FullName);

                //Копирование в mvc проект
                Console.WriteLine("Copy {0} {1}", src_path, dst_path);
                pathExplorer.Copy(src_path, dst_path);
            }
        }
    }
}
