﻿
import ApiQuery from '../Tools/ApiQuery'

const URL_download = "api/Explorer/GetFile?ID=";

export default class FileExplorerServices {
    constructor() {

        this.URL_DirectoryItems = "api/Explorer/GetDirectoryItems?ID=";
        this.URL_ScanDirectory = "api/Explorer/ScanDirectory?ID=";

        this.URL_Delete = "api/Explorer/DeleteFile";
        this.URL_Move = "api/Explorer/MoveElement";
        this.URL_Download = URL_download;
        this.URL_CreateDirectory = "api/Explorer/CreateDirectory?";

    }

    static staticURL_Download = URL_download;

    async DirectoryGetItemsAsync(ID) {
        let url = this.URL_DirectoryItems + ID;

        return await ApiQuery(url, "Get");
    }

    async ScanDirectoryAsync(ID) {
        let url = this.URL_ScanDirectory + ID;

        return await ApiQuery(url, "Get");
    }

    async DeleteAsync(ID) {

        return await ApiQuery(this.URL_Delete, "POST",
            {
                ID: ID
            });

    }

    async MoveAsync(elemID, directoryID) {
        return await ApiQuery(this.URL_Move, "POST",
            {
                ID: elemID,
                NewParent: directoryID
            });
    }


    OpenDownload(ID) {
        let url = this.URL_Download + ID;
        window.open(url, '_blank');
    }

    async CreateDirectoryAsync(dirname, id) {
        return await ApiQuery(this.URL_CreateDirectory, "POST",
            {
                ParentID: id,
                Name: dirname
            });
    }
}