﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Windows.Forms;

namespace NodeStarterTools.SolutionPaths
{
    public class PathExplorer
    {
        private readonly DirectoryInfo AppPath;

        //Путь к проекту
        public readonly DirectoryInfo SolutionPath;


        public PathExplorer()
        {
            AppPath = new DirectoryInfo(Path.GetDirectoryName(Application.ExecutablePath));
            SolutionPath = AppPath.Parent.Parent.Parent;
        }


        //Возвращает путь к проекту
        public DirectoryInfo GetSolutionPath(string ProjectName)
        {
            return new DirectoryInfo(SolutionPath.FullName + "\\" + ProjectName);
        }
        //Возвращает путь к проекту, включая папку в корне проекта
        public DirectoryInfo GetSolutionPath(string ProjectName, string Directory)
        {
            return new DirectoryInfo(SolutionPath.FullName + "\\" + ProjectName + "\\" + Directory);
        }
        //Возвращает путь к проекту, включая цепочку папок, начиная от корня проекта
        public DirectoryInfo GetSolutionPath(string ProjectName, params string[] Directorys)
        {
            StringBuilder res = new StringBuilder(SolutionPath.FullName + "\\" + ProjectName);

            foreach (var elem in Directorys)
                res.Append("\\" + elem);

            return new DirectoryInfo(res.ToString());
        }


        /// <summary>
        /// Пересоздать папки
        /// </summary>
        /// <param name="dirs">список папок (полные путь)</param>
        public void RecreateDirs(IEnumerable<string> dirs)
        {
            foreach (var elem in dirs)
            {
                if (Directory.Exists(elem))
                    Directory.Delete(elem, true);

                Directory.CreateDirectory(elem);
            }
        }

        /// <summary>
        /// Копирование файла
        /// Создает конечную папку, если таковая не создана
        /// </summary>
        /// <param name="src"></param>
        /// <param name="dst"></param>
        public void Copy(string src, string dst)
        {
            var dir = new FileInfo(dst).Directory;

            if (!dir.Exists)
                dir.Create();

            File.Copy(src, dst, true);
        }


        /// <summary>
        /// На основе пути path
        /// формирует относительный путь
        /// обрезая path от начала до dir (включая dir)
        /// </summary>
        /// <param name="path">Исходный путь</param>
        /// <param name="dir">Папка, относительно которой нужен путь</param>
        /// <param name="Prefix">Префикс, добавляемый к результату слева</param>
        /// <returns></returns>
        public string GetReleativePath(string path, string dir, string Prefix)
        {
            var dirs = path.Split('\\');

            StringBuilder res = new StringBuilder(Prefix);
            bool find_Skip = false;
            for (int i = 0; i < dirs.Length; i++)
            {
                if (!find_Skip)
                {
                    if (dirs[i] == dir)
                        find_Skip = true;
                }
                else
                    res.Append("\\" + dirs[i]);
            }

            return res.ToString();
        }
        public string GetReleativePath(string path, string dir)
        {
            return GetReleativePath(path, dir, "");
        }
        
    }
}
