﻿
import React from 'react';
import { Link } from 'react-router-dom';
import { Nav, Navbar, NavDropdown, MenuItem, NavItem, Alert } from 'react-bootstrap' 

import AuthServices from '../../Services/AuthServices'
import UserControl from '../Controls/User/UserControl.jsx'

import BaseControl from '../BaseControl.jsx'


import ImageFolder from '../../../Images/Folder.png'


export default class MenuControl extends BaseControl {

    constructor(props) {
        super(props, "MenuControl");

        this.authServices = new AuthServices();
        this.state = {
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User != undefined
                ? this.GlobalState.User.IsAdmin
                : false
        };

        this.EventRegister.RegisterListener("OnAuthChange", this);
    }

    Event_OnAuthChange() {
        this.setState({
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User.IsAdmin
        });
    }

    render() {

        return (
            <div>

                <Navbar bg="dark" variant="dark">
                    {/* "Link" in brand component since just redirect is needed */}
                    <Navbar.Brand><img
                        alt=""
                        src={ImageFolder}
                        width="30"
                        height="30"
                        className="d-inline-block align-top"
                    />
                        {' WebFileServer'}</Navbar.Brand>
                    <Nav>
                        {/* "NavLink" here since "active" class styling is needed */}
                        <Nav.Link as={Link} to='/'>Файлы</Nav.Link>

                        <NavDropdown title={this.state.IsAuth ? "Личный кабинет" : "Авторизация"}>
                            <UserControl ref="UserControl" />
                        </NavDropdown>

                        {this.state.IsAuth && this.state.IsAdmin
                            ?
                            <Nav.Link as={Link} to='/Admin'>Администрирование</Nav.Link>
                            : null
                        }                        
                </Nav>
                </Navbar>

                {!this.state.IsAuth
                    ? <Alert variant="warning"><b>Вы не авторизованы.</b></Alert>
                    : null
                }
                
            </div>
        );
    }
}

