﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.ComponentModel.DataAnnotations.Schema;
using System.Numerics;


using Model.Entities.Base;
using Model.Entities.Users;


namespace Model.Entities.Files.FS_Entities
{
    //[NotMapped]
    public class SFile : FS_Item
    {
        #region DB

        [Column("Size")]
        public long _Size { set; get; }

        #endregion

        #region GetProperty

        public override bool IsFile => true;

        public override string FileExtension => Path.GetExtension(Name);

        public override IReadOnlyList<FS_Item> Items => new List<FS_Item>();

        public override BigInteger Size => _Size;

        [NotMapped]
        private FileInfo _Info;
        public FileInfo Info
        {
            get
            {
                if (_Info == null)
                    _Info = new FileInfo(PhysicalPath);
                return _Info;
            }
        }

        #endregion


        [Obsolete]
        public SFile() { }

        public SFile(SDirectory parent, string Name, long size, User user) : base(Enum_BaseDirectoryEntity.File, parent, Name, user)
        {
            this._Size = size;
        }
        protected SFile(Enum_BaseDirectoryEntity type, SDirectory parent, string Name, long size, User user) : base(type, parent, Name, user)
        {
            this._Size = size;
        }
    }
}
