﻿
import React from 'react';
import { ReactTabulator } from 'react-tabulator'
import { Modal, Button, Form } from 'react-bootstrap' 

import Notification from '../../../Tools/Notification'

import UserServices from '../../../Services/UserServices'

import BaseControl from '../../BaseControl.jsx'

export default class RootDirListControl extends BaseControl {

    constructor(props) {
        super(props, "UserListControl");

        this.userServices = new UserServices();

        this.state = {
            RootDirs: [],
            ShoModalCreate: false
        };        
        

        this.columns = [
            { title: "ID", field: "ID" },
            { title: "Name", field: "Name" },

            { title: "Delete", formatter: this.ButtonFormatter, align: "center", cellClick: this.DeleteRootDirClick },
        ];

        this.DownloadRootDirs();
    }

    DownloadRootDirs() {
        this.userServices.GetRootDirsAsync().
            then(function (data) {
                let dirs = data.Dirs;
                this.setState({ RootDirs: dirs });

                this.EventRegister.EventAction("OnHaveDataChange", false);
            }.bind(this));
    }
    UploadRootDirs() {
        this.userServices.SetRootDirsAsync(this.state.RootDirs).
            then(function (data) {
                if (data.Successe)
                    Notification.MesOk(data.ResMessage, "Save");
                else
                    Notification.MesEr(data.ResMessage, "Save");

                this.DownloadRootDirs();
            }.bind(this));
    }

    //custom formatter definition
    ButtonFormatter(cell, formatterParams, onRendered) { //plain text value
        return "<i class='fa fa-print'><button>Action</button></i>";
    };

    OnCellChange(cell) {
        let dirs = this.state.RootDirs;

        let row = cell.getRow();
        let ID = row._row.data.ID;

        var data_row = dirs.filter(e => e.ID === ID)[0];

        //Если NoChange то Update
        if (data_row.Changes === 0)
            data_row.Changes = 1;

        this.EventRegister.EventAction("OnHaveDataChange", true);
    }

    UpdateClick() {
        this.DownloadRootDirs();
    }


    CreateRootDirClick() {
        this.setState({ ShoModalCreate: true });
    }

    CreateCompleteClick()
    {
        let dir_name = this.refs.NewDir_Name.value;

        let new_dir = this.userServices.CreateRootDir();
        new_dir.Name = dir_name;

        let dirs = this.state.RootDirs;
        dirs.push(new_dir);

        this.setState({
            RootDirs: dirs,
            ShoModalCreate: false
        });
        this.EventRegister.EventAction("OnHaveDataChange", true);
    }
    CreateCanselClick()
    {
        this.setState({ ShoModalCreate: false });
    }


    DeleteRootDirClick(e, cell) {
        //let table = this.refs.table.table;
        let row = cell.getRow();
        let ID = row._row.data.ID;

        let dirs = this.state.RootDirs;

        let dir = dirs.filter(e => e.ID === ID)[0];

        if (dir.Changes === 2) {
            dirs.splice(dirs.findIndex(e => e.ID === ID), 1);
        }
        else {
            dir.Changes = 3;
        }

        this.setState({ RootDirs: dirs });
        this.EventRegister.EventAction("OnHaveDataChange", true);
    }


    render() {
        return (
            <div>               
                <button onClick={this.CreateRootDirClick}>CreateRootDir</button>
                <button onClick={this.DownloadRootDirs}>Update(Изменения будут утеряны)</button>
                <button onClick={this.UploadRootDirs}>SaveChanges</button>


                <ReactTabulator ref="table"
                    data={this.state.RootDirs.filter(e => e.Changes != 3)}
                    columns={this.columns}
                    tooltips={true}
                    layout={"fitData"}

                    cellEdited={this.OnCellChange}
                />               

                <Modal ref="Modal"
                    show={this.state.ShoModalCreate}
                    onHide={this.CreateCanselClick}

                    size="lg"
                    aria-labelledby="contained-modal-title-vcenter"
                    centered
                >
                    <Modal.Header closeButton>
                        <Modal.Title>Create new RootDir</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <Form.Control ref="NewDir_Name" type="text" placeholder="Root dir name" style={{ marginBottom: 10 }} />
                    </Modal.Body>
                    <Modal.Footer>
                        <Button variant="primary" onClick={this.CreateCompleteClick}>
                            Create
                        </Button>
                        <Button variant="secondary" onClick={this.CreateCanselClick}>
                            Close
                        </Button>
                    </Modal.Footer>
                </Modal>

            </div>
        );
    }
}

