﻿
import React from 'react';
import { Modal, Button, InputGroup, FormControl, Row, Col, ButtonToolbar, ButtonGroup } from 'react-bootstrap'

import Notification from '../../../Tools/Notification'

import FileExplorerServices from '../../../Services/FileExplorerServices'

import BaseControl from '../../BaseControl.jsx'
import FileExplorerControl from '../FileExplorer/FileExplorerControl.jsx'


export default class ExplorerActionsControl extends BaseControl {

    constructor(props) {
        super(props, "ExplorerActionsControl");

        this.state =
        {
            MoveWindowsShow: false,
            CanWrite: false
        }
        this.fileExplorerServices = new FileExplorerServices();

        this.GlobalState.MoveExplorer = {
            ID: this.GlobalState.MainExplorer.ID,
            ShoSelectColumn: false,
            ChangeEvent: "OnItemsChange_Move"
        };

        this
            .EventRegister
            .RegisterListener(
                "OnItemsChange_MainExplorer_InfoLoaded",
                this
        );
    }

    Event_OnItemsChange_MainExplorer_InfoLoaded() {
        this.setState({
            CanWrite:
                this.GlobalState.MainExplorer.CanChangeDirectoryItems
        }
        );
    }

    OnDownloadClick(sender) {

        let selected = this.GlobalState.MainExplorer.
            ExplorerControl.GetSelectedID();

        selected.map((e) => {
            this.Log("OnDownload " + e);

            this.fileExplorerServices.OpenDownload(e);
        });
    }

    OnDeleteClick(sender) {

        let selected = this.GlobalState.MainExplorer.
            ExplorerControl.GetSelectedID();

        let promises = selected.map((e) => {
            this.Log("OnDelete " + e);
            return this.fileExplorerServices.DeleteAsync(e);
        });

        
        Promise.all(promises).then(function (data) {
            let Result = "";

            data.map(function (e) {
                Result += "Succese: " + e.Successe + " ResultMsg:" + e.ResMessage + " | ";
            });

            Notification.MesOk(Result, 'Move');

            this.EventRegister.
                EventAction(this.GlobalState.MainExplorer.ChangeEvent);
        }.bind(this));

    }

    OnCreateDirectoryClick(sender) {
        //debugger;
        let dirname = this.refs.DirectoryName.value;
        let id = this.GlobalState.MainExplorer.ID;

        this.fileExplorerServices.CreateDirectoryAsync(dirname, id).
            then(function (data) {
                this.EventRegister.
                    EventAction(this.GlobalState.MainExplorer.ChangeEvent);
                Notification.MesOk('Complete', 'CreateDir');
            }.bind(this));

        this.refs.DirectoryName.value = "";
    }


    OnMoveClick(sender) {
        let selected = this.GlobalState.MainExplorer.
            ExplorerControl.GetSelectedID();

        if (selected.length == 0)
            return;

        this.selected = selected;
        this.GlobalState.MoveExplorer.ID = this.GlobalState.MainExplorer.ID;
        this.EventRegister.EventAction("OnItemsChange_Move");

        this.setState({ MoveWindowsShow: true });
    }

    OnMoveWindowCloseClick() {
        this.setState({ MoveWindowsShow: false });
    }

    OnMoveWindowClick() {

        //Если src и dst папки одинаковы
        if (this.GlobalState.MainExplorer.ID == this.GlobalState.MoveExplorer.ID) {
            this.setState({ MoveWindowsShow: false });
            Notification.MesEr("Src dir == Dst dir", 'Move');
            return;
        }

        let promises = this.selected.map(function (e) {
            this.Log("OnMove " + e);
            debugger;
            return this.fileExplorerServices.
                MoveAsync(e, this.GlobalState.MoveExplorer.ID);
        }.bind(this));

        Promise.all(promises).then(function (data) {

            let Result = "";

            data.map(function (e){
                Result += "Succese: " + e.Successe + " ResultMsg:" + e.ResMessage + " | ";
            });
            
            //this.setState({ ResultMsg: Result });
            Notification.MesOk(Result, 'Move');
            this.EventRegister.
                EventAction(this.GlobalState.MainExplorer.ChangeEvent);
        }.bind(this));

        this.setState({ MoveWindowsShow: false });
    }






    render() {

        return (            
            <div className="jumbotron">

                <Row>                    
                    {
                        (this.state.CanWrite)
                        ?
                            <InputGroup className="mb-3">
                                <FormControl
                                    ref="DirectoryName" placeholder="Введите название"
                                />
                                <InputGroup.Append>
                                    <Button
                                        onClick={this.OnCreateDirectoryClick} variant="secondary"
                                    >
                                        Создать директорию
                            </Button>
                                </InputGroup.Append>
                            </InputGroup>
                        : null
                    }

                    
                </Row>
                <Row variant="no-gutters">
                    <ButtonToolbar className="mb-3">
                        {
                            (this.state.CanWrite)
                                ?
                                <ButtonGroup className="mr-2">
                                    <Button
                                        onClick={this.OnDownloadClick} variant="success">
                                        Скачать
                                    </Button>
                                    <Button
                                        onClick={this.OnMoveClick} variant="warning" disabled={!this.state.CanWrite}>
                                        Переместить
                                    </Button>
                                    <Button
                                        onClick={this.OnDeleteClick} variant="danger" disabled={!this.state.CanWrite}>
                                        Удалить
                                    </Button>
                                </ButtonGroup>
                                :
                                <div>
                                    <h3>Вы не можете менять содержимое данной папки</h3>

                                    <ButtonGroup className="mr-2">                                        
                                        <Button
                                            onClick={this.OnDownloadClick} variant="success">
                                            Скачать
                                    </Button>
                                    </ButtonGroup>
                                </div>
                        }
                        {
                            /*<InputGroup>
                                <FormControl placeholder="Поиск по названию" />
                                <InputGroup.Append>
                                    <Button variant="secondary">Найти</Button>
                                </InputGroup.Append>
                            </InputGroup>*/
                        }
                    </ButtonToolbar>
                </Row>                                      

                <Modal ref="Modal"
                    show={this.state.MoveWindowsShow}
                    onHide={this.OnMoveWindowCloseClick}

                    size="lg"
                    centered
                >
                    <Modal.Header closeButton>
                        <Modal.Title>Select destination directory</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <FileExplorerControl ref="FileExplorerControl"
                            ParentComponent={this}
                            CurrentDirectoryName={"MoveExplorer"}
                        />
                    </Modal.Body>
                    <Modal.Footer>
                        <Button variant="secondary" onClick={this.OnMoveWindowCloseClick}>
                            Cansel
                        </Button>
                        <Button variant="primary" onClick={this.OnMoveWindowClick}>
                            Move to directory
                        </Button>
                    </Modal.Footer>
                </Modal>
            </div>
        );

    }
}
