﻿
import React from 'react';
import { Link } from 'react-router-dom';
import { Form, Button, Alert } from 'react-bootstrap' 

import Notification from '../../../Tools/Notification'

import AuthServices from '../../../Services/AuthServices'

import BaseControl from '../../BaseControl.jsx'



export default class UserControl extends BaseControl {

    constructor(props) {
        super(props, "UserControl");

        this.authServices = new AuthServices();
        this.state = {
            IsAuth: this.authServices.IsAuth(),
            CurrentUser: this.GlobalState.User != undefined
                ? this.GlobalState.User
                : this.UserInfo(null)
        };

        if (this.authServices.IsAuth())
            this.authServices.GetUserInfoAsync().then(function (data) {

                if (data.Successe) {
                    this.GlobalState.User = this.UserInfo(data.User);
                }
                else {
                    this.GlobalState.User = this.UserInfo(null);                   

                    Notification.MesEr(data.ResMessage, "Auth");
                }

                this.setState ({
                    IsAuth: this.authServices.IsAuth(),
                    CurrentUser: this.GlobalState.User
                });
                this.EventRegister.EventAction("OnAuthChange");

            }.bind(this));
    }

    UserInfo(user) {
        if (user == null)
            return {
                Login: "",
                IsAdmin: false
            };

        return {
            Login: user.Login,
            IsAdmin: user.IsAdmin
        };
    }

    //Кнопка входа
    AuthClick() {
        let login = this.refs.Login.value;
        let password = this.refs.Password.value;

        this.authServices.AuthAsync(login, password)
            .then(function (data) {

                if (data.Successe) {
                    this.GlobalState.User = this.UserInfo(data.User);
                }
                else {
                    this.GlobalState.User = this.UserInfo(null);

                    Notification.MesEr_Hide(data.ResMessage, "Auth");
                }

                this.setState({
                    IsAuth: this.authServices.IsAuth(),
                    CurrentUser: this.GlobalState.User
                });
                this.EventRegister.EventAction("OnAuthChange");

            }.bind(this));
    }

    //Кнопка выхода
    LogoutClick() {
        this.authServices.Logout();
        this.GlobalState.User = this.UserInfo(null);

        this.setState({
            IsAuth: this.authServices.IsAuth(),
            CurrentUser: this.GlobalState.User
        });
        this.EventRegister.EventAction("OnAuthChange");
    }


    render() {
        let state = this.state;

        return (
            <div>
                {this.state.IsAuth
                    ?
                    <div>                       
                        <Alert variant="success" style={{ margin: 0, marginBottom: 10, padding: 0 }}>Пользователь: {this.state.CurrentUser.Login}.</Alert>
                        {this.state.CurrentUser.IsAdmin
                            ? <Alert variant="success" style={{ margin: 0, marginBottom: 10, padding: 0 }}>Вы администратор.</Alert>                        
                            : null
                        }
                        <Button as={Link} to="/User" variant="outline-secondary" style={{ marginBottom: 10 }}>Изменить пароль</Button>
                        <Button onClick={this.LogoutClick} variant="danger">Выход</Button>
                    </div>
                    :
                    <div>
                        {/*<Form.Label>Email address</Form.Label>*/}
                        <Form.Control ref="Login" type="text" placeholder="Enter login" style={{ marginBottom: 10}}/>
                        
                        {/*<Form.Label>Password</Form.Label>*/}
                        <Form.Control ref="Password" type="password" placeholder="Password" style={{ marginBottom: 10 }}/>
                        <Button onClick={this.AuthClick} variant="success">Авторизация</Button>
                    </div>
                }
            </div>
        );
    }
}
