﻿
import React from 'react';
import { Button, InputGroup, FormControl, ProgressBar, Card, Table } from 'react-bootstrap' 

import Notification from '../../../Tools/Notification'

import UploadServices from '../../../Services/UploadServices'

import BaseControl from '../../BaseControl.jsx'


export default class UploaderControl extends BaseControl {

    constructor(props) {
        super(props, "UploaderControl");

        //state 0 - выбор файла
        //state 1 - загрузка
        this.state = {
            progress: 0,
            UploadedSize: 0,
            _state: 0,
            FileInfo: {},
            ResultMsg: "",
            CanWrite: false
        };


        this.uploadServices = new UploadServices();
        this.uploadServices.OnProggresseChange = this.OnProgresseChange;
        //this.uploadServices.OnIDReceived = null;

        this
            .EventRegister
            .RegisterListener(
                "OnItemsChange_MainExplorer_InfoLoaded",
                this
            );
    }

    Event_OnItemsChange_MainExplorer_InfoLoaded() {
        this.setState({
            CanWrite:
                this.GlobalState.MainExplorer.CanChangeDirectoryItems
        }
        );

        //debugger;
    }


    UploadClick() {

        let input = this.refs.file;
        let files = input.files;


        if (files.length == 0)
            return;
        let file = files[0];

        this.setState({
            _state: 1,
            FileInfo: {
                name: file.name,
                size: file.size
            }
        });

        this.uploadServices.UploadFileAsync(
            file,
            this.GlobalState.MainExplorer.ID
        ).then(
            function () {
                Notification.MesOk_NoHide('Complete', 'Upload');
                input.value = "";

                this.setState({
                    _state: 0,
                    FileInfo: {}
                });
                this.EventRegister.EventAction(this.GlobalState.MainExplorer.ChangeEvent);
            }.bind(this),
            function (error_data) {
                Notification.MesEr(error_data.ResMessage, "Upload");

                this.setState({
                    progress: 0,
                    _state: 0,
                    FileInfo: {}
                });
            }.bind(this)
        );
    }

    CancelClick() {
        this.uploadServices.Cansel();
        this.setState({
            _state: 0,
            FileInfo: {}
        });
    }

    OnProgresseChange(Process, size) {
        this.setState({
            progress: Process,
            UploadedSize: size
        });
    }


    render() {
        return (
            (
                this.state._state == 0 &&
                !this.state.CanWrite
            )
                ?
                <div className="jumbotron">
                    <h2>Вы не можете загрузить данные в эту папку</h2>
                </div>
                :
                <div className="jumbotron">

                    <h3>Загрузка файлов</h3>
                    <InputGroup>
                        <FormControl ref="file" type="file" disabled={this.state._state !== 0} />
                        <InputGroup.Append>
                            <Button disabled={this.state._state !== 0} onClick={this.UploadClick} variant="outline-success">Загрузить</Button>
                            <Button disabled={this.state._state !== 1} onClick={this.CancelClick} variant="outline-danger">Отмена</Button>
                        </InputGroup.Append>
                    </InputGroup>

                    {
                        this.state._state == 1

                            ?
                            <div>
                                <Card>
                                    <Card.Body>
                                        <Card.Title>Выполняется загрука файлов</Card.Title>
                                        <Table bordered size="sm">
                                            <thead>
                                                <tr>
                                                    <th>Имя</th>
                                                    <th>Размер</th>
                                                    <th>Прогресс</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>{this.state.FileInfo.name}</td>
                                                    <td>{this.state.FileInfo.size}</td>
                                                    <td>
                                                        <ProgressBar now={this.state.progress} label={`${this.state.progress}%`} />
                                                        {this.state.UploadedSize}
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </Table>
                                    </Card.Body>
                                </Card>
                            </div>
                            : ""
                    }
                </div>
        )
    }
}