﻿
import ApiQuery from '../Tools/ApiQuery'

export default class FileExplorerServices {
    constructor() {

        this.URL_DirectoryItems = "api/Explorer/GetDirectoryItems?ID=";
        this.URL_ScanDirectory = "api/Explorer/ScanDirectory?ID=";

        this.URL_Delete = "api/Explorer/DeleteFile";
        this.URL_Move = "api/Explorer/MoveElement";
        this.URL_Download = "api/Explorer/GetFile?ID=";
        this.URL_CreateDirectory = "api/Explorer/CreateDirectory?";

        this.URL_CreateOneLink = "api/Explorer/CreateOneLink";
    }

    async DirectoryGetItemsAsync(ID) {
        let url = this.URL_DirectoryItems + ID;

        return await ApiQuery(url, "Get");
    }

    async ScanDirectoryAsync(ID) {
        let url = this.URL_ScanDirectory + ID;

        return await ApiQuery(url, "Get");
    }

    async DeleteAsync(ID) {

        return await ApiQuery(this.URL_Delete, "POST",
            {
                ID: ID
            });

    }

    async MoveAsync(elemID, directoryID) {
        return await ApiQuery(this.URL_Move, "POST",
            {
                ID: elemID,
                NewParent: directoryID
            });
    }


    OpenDownload(ID) {
        let url = this.URL_Download + ID;
        window.open(url, '_blank');
    }

    async CreateDirectoryAsync(dirname, id) {
        return await ApiQuery(this.URL_CreateDirectory, "POST",
            {
                ParentID: id,
                Name: dirname
            });
    }

    async CreateTmpLink(ID) {
        return await ApiQuery(
            this.URL_CreateOneLink + '?ID=' + ID,
            "GET"
        );
    }

}