﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using NodeStarterTools.SolutionPaths;

namespace NodeStarterTools
{

    /// <summary>
    /// Не самый лучший критерий проверки (По имени npm)
    /// Проверка есть ли npm окно при запуске debug dev
    /// </summary>
    public enum EnumDevMode
    {
        NoCheckExists, //Не проверять
        IfExistsNoRun, //Если процесс присутствует, то не запускать
        IfExistsReload //Если процесс пресутствует, то перезапустить
    }

    public class Config
    {
        #region       
        /// <summary>
        /// Запускать ли SPA модуль
        /// </summary>
        public readonly bool RunSPA = true;
        public readonly EnumDevMode DebugDevMode = EnumDevMode.IfExistsNoRun;

        #endregion

        #region

        //Путь к SPA проекту
        public readonly DirectoryInfo SPAProject;


        /// Папка в которой находится бандл
        public readonly DirectoryInfo SPAProjectBuild;

        /// Папка, в которую размещается Release js бандла
        public readonly DirectoryInfo WebProjectSPA;

        #endregion


        public Config()
        {
            PathExplorer pathExplorer = new PathExplorer();

            SPAProject = pathExplorer.GetSolutionPath("SPA");

            SPAProjectBuild = pathExplorer.GetSolutionPath("SPA", "SPA_Build");
            WebProjectSPA = pathExplorer.GetSolutionPath("Web", "SPA_Build");
        }
    }
}
