﻿
import React from 'react';
import { Prompt } from 'react-router'
import { Nav } from 'react-bootstrap' 

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'
import UserListControl from '../Controls/Admin/UserListControl.jsx'
import GroupListControl from '../Controls/Admin/GroupListControl.jsx'
import RootDirListControl from '../Controls/Admin/RootDirListControl.jsx'


export default class AdministratorPage extends BaseControl {

    constructor(props) {
        super(props, "AdministratorPage");

        this.authServices = new AuthServices();
        //ActiveTab : 0 Users, 1 Groups, 2 RootDirs
        this.state = {
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User != undefined
                ? this.GlobalState.User.IsAdmin
                : false,
            HaveChanges: false,
            ActiveTab: 0
        };        

        this.EventRegister.RegisterListener("OnAuthChange", this);
        this.EventRegister.RegisterListener("OnHaveDataChange", this);
    }

    Event_OnAuthChange() {
        this.setState({
            IsAuth: this.authServices.IsAuth(),
            IsAdmin: this.GlobalState.User.IsAdmin
        });
    }

    Event_OnHaveDataChange(HaveChanges) {
        this.setState({ HaveChanges: HaveChanges });
    }

    OnUsersClick() {
        if (this.state.ActiveTab == 0)
            return;

        //Несохраненные изменения
        if (this.state.HaveChanges) 
            if (!confirm("You have unsaved changes. Are you sure you want to leave this table?"))
                return;       

        this.setState({ ActiveTab: 0 });
    }
    OnGroupsClick() {
        if (this.state.ActiveTab == 1)
            return;

        //Несохраненные изменения
        if (this.state.HaveChanges)
            if (!confirm("You have unsaved changes. Are you sure you want to leave this table?"))
                return;  

        this.setState({ ActiveTab: 1 });
    }
    OnRootDirsClick() {
        if (this.state.ActiveTab == 2)
            return;

        //Несохраненные изменения
        if (this.state.HaveChanges)
            if (!confirm("You have unsaved changes. Are you sure you want to leave this table?"))
                return;

        this.setState({ ActiveTab: 2 });
    }



    render() {

        const TabRender = () => {
            switch (this.state.ActiveTab) {
                case 0: return <UserListControl ref="UserListControl" /> ;
                case 1: return <GroupListControl ref="GroupListControl" />;
                case 2: return <RootDirListControl ref="RootDirListControl" />;
            }
        }

        return (
            <div>
                {/*Несохраненные изменения*/}
                {this.state.HaveChanges
                    ? <p>!Есть несохраненные изменения</p>
                    : null
                }
                <Prompt
                    when={this.state.HaveChanges}
                    message="You have unsaved changes. Are you sure you want to leave this page?"
                />


                {this.state.IsAdmin
                    ?
                    <div>
                        <Nav variant="tabs">
                            <Nav.Item>
                                <Nav.Link onClick={this.OnUsersClick}>Users</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link onClick={this.OnGroupsClick}>Groups</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link onClick={this.OnRootDirsClick}>Root dirs</Nav.Link>
                            </Nav.Item>
                        </Nav>

                        {TabRender()}

                    </div>
                    : <p>Вы не являетесь администратором</p>
                }

            </div>
        );
    }
}

