﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.Threading.Tasks;
using System.Text;
using System.Data.Entity;

using Model.Entities.Users;
using Model.ViewModel.Edit;
using Web.Models.Base;
using BLL.Services.FS;
using BLL.Services.Mapper;


namespace Web.Controllers.API.Admin
{

    public class UsersController : Base.BaseApiController
    {
        readonly ScanServices ScanServices;

        readonly UserMapper UserMapper;
        readonly GroupMapper GroupMapper;
        readonly RootDirsMapper RootDirsMapper;

        public UsersController()
        {
            ScanServices = new ScanServices(UOW);

            UserMapper = new UserMapper(UOW, permissionServices);
            GroupMapper = new GroupMapper(UOW, permissionServices);
            RootDirsMapper = new RootDirsMapper(UOW, permissionServices, () => Server.MapPath("~/App_Data"));
        }

        [HttpPost]
        public JsonResult GetUserList()
        {
            if (CurrentUser == null || (CurrentUser != null && !CurrentUser.IsAdmin))
                return new UserListMode(this, false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                }.ToJson;

            return new UserListMode(this, true)
            {
                Users = UserMapper.GetEdit_User(),
                Groups = GroupMapper.GetInfo_Group()
            }.ToJson;
        }
        [HttpPost]
        public JsonResult SetUserList(List<EditUserModel> model)
        {
            if (CurrentUser == null || (CurrentUser != null && !CurrentUser.IsAdmin))
                return new BaseApiResult(this, false, "").ToJson;

            StringBuilder res = new StringBuilder();
            bool HaveErr = false;

            var Users = UserMapper.GetEntities_User(model);

            foreach (var elem in Users)
            {
                try
                {
                    switch (elem.Edited.Changes)
                    {
                        case EnumChanges.Create:
                            UOW.Repo_User.Create(elem.DBUser);

                            res.Append(elem.Edited.Name + "|Cr|");
                            break;
                        case EnumChanges.Update:
                            UOW.Repo_User.Update(elem.DBUser);

                            res.Append(elem.Edited.Name + "|Up|");
                            break;
                        case EnumChanges.Delete:
                            UOW.Repo_User.Delete(elem.DBUser);

                            res.Append(elem.Edited.Name + "|De|");
                            break;
                    }
                }
                catch (Exception ex)
                {
                    res.Append(elem.Edited.Name + "|Error|" + ex.Message);
                    HaveErr = true;
                }
            }

            return new BaseApiResult(this, !HaveErr, res.ToString()).ToJson;
        }

        public class UserListMode : BaseApiResult
        {
            public UserListMode(Base.BaseController controller, bool Successe) : base(controller, Successe, "") { }

            public List<EditUserModel> Users;
            public List<InfoGroupModel> Groups;
        }



        [HttpPost]
        public JsonResult GetGroupList()
        {
            if (CurrentUser == null || (CurrentUser != null && !CurrentUser.IsAdmin))
                return new GroupListMode(this, false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                }.ToJson;

            return new GroupListMode(this, true)
            {
                Groups = GroupMapper.GetEdit_Group(),
                RootDirs = RootDirsMapper.GetInfo_RootDir()
            }.ToJson;
        }
        [HttpPost]
        public JsonResult SetGroupList(List<EditGroupModel> model)
        {
            if (CurrentUser == null || (CurrentUser != null && !CurrentUser.IsAdmin))
                return new BaseApiResult(this, false, "Need admin").ToJson;

            StringBuilder res = new StringBuilder();
            bool HaveErr = false;

            var Groups = GroupMapper.GetEntities_Group(model);

            foreach (var elem in Groups)
            {
                try
                {
                    switch (elem.Edited.Changes)
                    {
                        case EnumChanges.Create:
                            UOW.Repo_Group.Create(elem.DB);

                            res.Append(elem.Edited.Name + "|Cr|");
                            break;
                        case EnumChanges.Update:
                            UOW.Repo_Group.Update(elem.DB);

                            res.Append(elem.Edited.Name + "|Up|");
                            break;
                        case EnumChanges.Delete:
                            UOW.Repo_Group.Delete(elem.DB);

                            res.Append(elem.Edited.Name + "|De|");
                            break;
                    }
                }
                catch (Exception ex)
                {
                    res.Append(elem.Edited.Name + "|Error|" + ex.Message);
                    HaveErr = true;
                }
            }

            return new BaseApiResult(this, !HaveErr, res.ToString()).ToJson;
        }

        public class GroupListMode : BaseApiResult
        {
            public GroupListMode(Base.BaseController controller, bool Successe) : base(controller, Successe, "") { }

            public List<EditGroupModel> Groups;
            public List<InfoRootDirModel> RootDirs;
        }



        [HttpPost]
        public JsonResult GetRootDirList()
        {
            if (CurrentUser == null || (CurrentUser != null && !CurrentUser.IsAdmin))
                return new RootDirsListMode(this, false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"
                }.ToJson;

            return new RootDirsListMode(this, true)
            {
                Dirs = RootDirsMapper.GetEdit_Group()
            }.ToJson;
        }
        [HttpPost]
        public async Task<JsonResult> SetRootDirList(List<EditRootDirModel> model)
        {
            if (CurrentUser == null || (CurrentUser != null && !CurrentUser.IsAdmin))
                return new BaseApiResult(this, false, "Need admin").ToJson;

            StringBuilder res = new StringBuilder();
            bool HaveErr = false;

            var Groups = RootDirsMapper.GetEntities_RootDir(model);

            foreach (var elem in Groups)
            {
                try
                {
                    switch (elem.Edited.Changes)
                    {
                        case EnumChanges.Create:
                            UOW.Repo_SRootDirectory.Create(elem.DB);
                            await ScanServices.RecursScanDirectoryAsync(elem.DB, true);

                            res.Append(elem.Edited.Name + "|Cr|");
                            break;
                        case EnumChanges.Update:
                            UOW.Repo_SRootDirectory.Update(elem.DB);

                            res.Append(elem.Edited.Name + "|Up|");
                            break;
                        case EnumChanges.Delete:
                            UOW.Repo_SRootDirectory.DeleteInList(elem.DB);

                            res.Append(elem.Edited.Name + "|De|");
                            break;
                    }
                }
                catch (Exception ex)
                {
                    res.Append(elem.Edited.Name + "|Error|" + ex.Message);
                    HaveErr = true;
                }
            }

            return new BaseApiResult(this, !HaveErr, res.ToString()).ToJson;
        }

        public class RootDirsListMode : BaseApiResult
        {
            public RootDirsListMode(Base.BaseController controller, bool Successe) : base(controller, Successe, "") { }

            public List<EditRootDirModel> Dirs;
        }

    }
}