﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Model.UnitsOfWork;
using BLL.Services.FS;

namespace Web.Controllers.Base
{
    public abstract class BaseController : Controller
    {
        protected UOW UOW = new UOW();
        protected UploadServices uploadServices;


        public string ControllerName => Request.RequestContext.RouteData
            .Values["controller"].ToString();
        public string ActionName => Request.RequestContext.RouteData
            .Values["action"].ToString();


        public BaseController()
        {
            uploadServices = new UploadServices(UOW);
        }


        public JsonResult ToJson(Object model)
        {
            return Json(model, JsonRequestBehavior.AllowGet);
        }


        #region Dispose

        ~BaseController()
        {
            Dispose(false);
        }

        protected override void Dispose(bool disposing)
        {
            //UOW.Dispose();
            base.Dispose(disposing);
        }

        #endregion

    }
}
