
import React from 'react';
import autoBind from 'react-autobind';

import ControlRegister from '../Registers/ControlRegister'
import EventRegister from '../Registers/EventRegister'
import { ControlLog as Log } from '../Tools/LogTools'


export default class BaseControl extends React.Component {

    static controlRegister = ControlRegister.Get();
    static eventRegister = EventRegister.Get();    

    //  
    static GlobalState = {};
    

    constructor(props, name) {
        super(props);
        this.Name = name;
        autoBind(this);

        this.GlobalState = BaseControl.GlobalState;
        this.EventRegister = BaseControl.eventRegister;        
        this._isMounted = false;

        //    
        this.Log = (Msg) => { Log(this, Msg); };

        //    
        BaseControl.controlRegister.RegisterControl(this);

        this.Log("start");
    }

    //  promise (  api)
    //      (componentDidMount)
    //    then(...this.setState(...)...).bind(this)  
    setState(new_state) {
        if (!this._isMounted)
            return;

        super.setState(new_state);
    }

    componentDidMount() {
        this._isMounted = true;
    }

    componentWillUnmount() {
        this._isMounted = false;
        //console.log(this.name + " stop " + this.ID);

        //   
        BaseControl.controlRegister.UnregisterControl(this);

        //     ,      
        if (this.IsEventListener === true)
            BaseControl.eventRegister.UnregistListener(this);
    }
}
