
// path       
const path = require('path');


module.exports = {

    // .      
    devtool: 'source-map',

    //  (index.js)
    entry: {
        app: "./src/index.js"
    },    

    //
    output: {
        // 
        //[name] -    (app__bundle.js)
        filename: "[name]_bundle.js",
        // 
        path: path.resolve(__dirname, "./build"),
        //  dev 
        publicPath: "/build"
    },

    //     
    module: {
        // 
        rules: [

        // js
            {
                // . .  
                test: /\.js$/,
                //  ( )
                loader: 'babel-loader',
                //      node_modules (..   )
                exclude: '/node_modules/'
            },
        // jsx
            {
                //   
                test: /\.jsx?$/, 
                exclude: /(node_modules)/,
                //  
                loader: "babel-loader"
            }
        ]
    },

    // dev 
    devServer: {

        port: 8081,
        //   
        overlay: true,
        // 
        openPage: 'build/index.html',
        //SPA route.  index     
        historyApiFallback: {
            index: 'index.html'
        },

        proxy: {            

            // WevAPI
            '/api/*': {
                target: 'http://localhost:47780'
            }
        }
    }

}