﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using BLL.Services.System;
using BLL.Services.Mapper;
using Model.ViewModel.Edit;
using Model.ViewModel;

using Web.Models.Base;

namespace Web.Controllers.API
{

    public class AuthResult : BaseApiResult
    {
        public AuthResult(bool Successe, string ResMsg, string Token, UserInfoModel userInfoModel) : base(Successe, ResMsg, "Auth")
        {
            this.Token = Token;
            this.User = userInfoModel;
        }

        public string Token { set; get; }

        public UserInfoModel User { set; get; }

        //public string UserName { set; get; }
    }


    public class AuthController : Base.BaseApiController
    {
        readonly UserMapper UserMapper;


        public AuthController()
        {
            UserMapper = new UserMapper(UOW, permissionServices);
        }

        /// <summary>
        /// Должен выдавать токен авторизации
        /// </summary>
        /// <param name="Login"></param>
        /// <param name="Password"></param>
        /// <returns></returns>
        /// 
        [HttpPost]
        public JsonResult Auth(string Login, string Password)
        {
            var user = UOW.Repo_User.All_NoTrack.
                FirstOrDefault(e => e.Login == Login && e.Password == Password
                && e.IsActive);

            if (user != null)
            {
                return Json(new AuthResult(
                    true,
                    "",
                    TokenServices.CreateTocken(user.ID, new TimeSpan(1, 0, 0)),
                    UserMapper.GetUserInfo(user))
                    );
            }
            else
            {
                return Json(new AuthResult(
                    false,
                    "Пользователь не найден или заблокирован/Время авторизации истекло",
                    "", null));
            }
        }


        [HttpPost]
        public JsonResult UserInfo()
        {
            if (CurrentUser != null)
            {
                return Json(new AuthResult(
                    true,
                    "",
                    TokenServices.CreateTocken(CurrentUser.ID, new TimeSpan(1, 0, 0)),
                    UserMapper.GetUserInfo(CurrentUser))
                    );
            }
            else
            {
                return Json(new AuthResult(
                    false,
                    "Пользователь не найден или заблокирован",
                    "",
                    null)
                    );
            }
        }

        [HttpPost]
        public JsonResult SetUser(UserInfoModel model)
        {
            if (CurrentUser == null)
            {
                return Json(new BaseApiResult(
                    false,
                    "Пользователь не найден или заблокирован",
                    "SetUser")
                    );
            }

            string ResMsg = "";
            if (!string.IsNullOrEmpty(model.Password))
            {
                CurrentUser.Password = model.Password;
                UOW.Repo_User.Update(CurrentUser);

                ResMsg = CurrentUser.Login + " Password update";
            }

            return Json(new BaseApiResult(true, ResMsg, "SetUser"));
        }

        public class UserInfoModel
        {
            public string Login { set; get; }
            public string Password { set; get; }
            public string IsAdmin { set; get; }

            public List<RootDirInfo> RootDirs { set; get; }
        }


    }
}