﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using ExpressionOperatorProxy.Generic.MathOperatorProxy;
using ExpressionOperatorProxy.Generic.Collection;

namespace ConsoleTest
{
    class Program
    {

        //OperatorProxy example
        static void Test1()
        {
            var a = new OperatorProxy<int>(10);
            var b = new OperatorProxy<int>(20);
            var c = 2;

            var res = a + b * c;
            Console.WriteLine(res);
        }

        //Matrix example
        static void Test2()
        {
            var m1 = new Matrix<int>(new List<List<int>>()
            {
                new List<int>(){ 1, 2, 3 },
                new List<int>(){ 3, 2, 1 }
            });

            var m2 = new Matrix<int>(new List<List<int>>()
            {
                new List<int>(){ -1, -2, -3 },
                new List<int>(){ 3, 2, 1 }
            });

            var res = m1 + m2;
            Console.WriteLine(res);
        }

        class TestClass { }
        //Error example
        //TestClass not implement + operator
        static void Test3()
        {
            var a = new OperatorProxy<TestClass>(new TestClass());
            var b = new OperatorProxy<TestClass>(new TestClass());

            var res = a + b;
        }

        static void Main(string[] args)
        {
            Test1();
            Test2();
            //Test3();
        }
    }
}
