﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;
using System.Drawing;

using yEd.XGML.DocumentEntities.EdgeEntitie;
using yEd.XGML.Enums;

namespace yEd.XGML.IO.Read
{
    public class EdgeReader : IReader<Edge>
    {
        public Edge Read(XElement element)
        {
            Edge res = new Edge();

            res.source = int.Parse(element.GetChild_Attribute("source").Value);
            res.target = int.Parse(element.GetChild_Attribute("target").Value);
            res.label = element.GetChild_Attribute("label")?.Value;

            res.Graphics = Readgraphics(element.GetChild_Section("graphics"));
            res.LabelGraphics = ReadLabelGraphics(element.GetChild_Section("LabelGraphics"));

            return res;
        }

        private EdgeGraphics Readgraphics(XElement graphics)
        {
            EdgeGraphics res = new EdgeGraphics();

            res.fill = ColorTranslator.FromHtml(graphics.GetChild_Attribute("fill").Value);
            res.targetArrow = (EnumArrowType)Enum.Parse(typeof(EnumArrowType), graphics.GetChild_Attribute("targetArrow").Value);

            return res;
        }

        private EdgeLabelGraphics ReadLabelGraphics(XElement label)
        {
            if (label == null)
                return null;

            EdgeLabelGraphics res = new EdgeLabelGraphics();

            res.fontSize = int.Parse(label.GetChild_Attribute("fontSize").Value);
            res.fontName = (EnumFont)Enum.Parse(typeof(EnumFont), label.GetChild_Attribute("fontName").Value);
            res.contentWidth = double.Parse(label.GetChild_Attribute("contentWidth").Value);
            res.contentHeight = double.Parse(label.GetChild_Attribute("contentHeight").Value);

            return res;
        }
    }
}
