﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Xml.Linq;

using yEd.XGML.IO.Write;
using yEd.XGML.IO.Write.Tools;
using yEd.XGML.DocumentEntities;
using yEd.XGML.DocumentEntities.NodeEntitie;
using yEd.XGML.DocumentEntities.GroupNodeEntitie;

namespace yEd.XGML.IO
{
    /// <summary>
    /// Класс для записи Document в yed XGML файл
    /// </summary>
    public class XGML_Writer
    {
        public XDocument Write(Document document)
        {
            XDocument res = new XDocument();

            XElement root = XElement_Tools.CreateSection("xgml");
            res.Add(root);

            root.Add(XElement_Tools.CreateAttribute("Creator", "String", document.Creator));
            root.Add(XElement_Tools.CreateAttribute("Version", "String", document.Version));


            XElement graph = XElement_Tools.CreateSection("graph");

            graph.Add(XElement_Tools.CreateAttribute("hierarchic", "int", document.hierarchic));
            graph.Add(XElement_Tools.CreateAttribute("label", "String", document.label));
            graph.Add(XElement_Tools.CreateAttribute("directed", "int", document.directed));


            NodeWriter nodeWriter = new NodeWriter();
            GroupNodeWriter groupNodeWriter = new GroupNodeWriter();
            EdgeWriter edgeWriter = new EdgeWriter();

            foreach (var elem in document.Elements)
            {
                if (elem.Value.isGroup)
                    graph.Add(groupNodeWriter.Write((GroupNode)elem.Value));
                else
                    graph.Add(nodeWriter.Write((Node)elem.Value));
            }

            foreach (var elem in document.Edges)
            {
                graph.Add(edgeWriter.Write(elem));
            }

            root.Add(graph);

            return res;
        }

        public void Write(Document document, string file) =>
            Write(document).Save(file);

        public void Write(Document document, Stream stream) =>
            Write(document).Save(stream);
    }
}
