﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;
using System.Drawing;

using yEd.XGML.DocumentEntities.GroupNodeEntitie;
using yEd.XGML.Enums;

namespace yEd.XGML.IO.Read
{
    internal class NodeGroupReader : IReader<GroupNode>
    {
        public GroupNode Read(XElement element)
        {
            GroupNode res = new GroupNode();

            res.id = int.Parse(element.GetChild_Attribute("id").Value);
            res.label = element.GetChild_Attribute("label").Value;

            res.graphics = ReadGroupsNodeGraphics(element.GetChild_Section("graphics"));
            res.LabelGraphics = ReadGroupNodeLabelGraphics(element.GetChild_Section("LabelGraphics"));

            var gid_attrib = element.GetChild_Attribute("gid");
            if (gid_attrib != null)
                res.gid = int.Parse(gid_attrib.Value);

            return res;
        }

        private GroupsNodeGraphics ReadGroupsNodeGraphics(XElement graphics)
        {
            GroupsNodeGraphics res = new GroupsNodeGraphics();

            res.x = double.Parse(graphics.GetChild_Attribute("x").Value);
            res.y = double.Parse(graphics.GetChild_Attribute("y").Value);
            res.w = double.Parse(graphics.GetChild_Attribute("w").Value);
            res.h = double.Parse(graphics.GetChild_Attribute("h").Value);
            res.type = (EnumNodeType)Enum.Parse(typeof(EnumNodeType), graphics.GetChild_Attribute("type").Value);
            res.fill = ColorTranslator.FromHtml(graphics.GetChild_Attribute("fill").Value);
            res.outline = ColorTranslator.FromHtml(graphics.GetChild_Attribute("outline").Value);
            res.topBorderInset = double.Parse(graphics.GetChild_Attribute("topBorderInset").Value);
            res.bottomBorderInset = double.Parse(graphics.GetChild_Attribute("bottomBorderInset").Value);
            res.leftBorderInset = double.Parse(graphics.GetChild_Attribute("leftBorderInset").Value);
            res.rightBorderInset = double.Parse(graphics.GetChild_Attribute("rightBorderInset").Value);

            return res;
        }

        private GroupNodeLabelGraphics ReadGroupNodeLabelGraphics(XElement LabelGraphics)
        {
            GroupNodeLabelGraphics res = new GroupNodeLabelGraphics();

            res.fill = ColorTranslator.FromHtml(LabelGraphics.GetChild_Attribute("fill").Value);
            res.fontSize = int.Parse(LabelGraphics.GetChild_Attribute("fontSize").Value);
            res.fontName = (EnumFont)Enum.Parse(typeof(EnumFont), LabelGraphics.GetChild_Attribute("fontName").Value);
            res.borderDistance = double.Parse(LabelGraphics.GetChild_Attribute("borderDistance").Value);

            return res;
        }

    }
}
