﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using yEd.XGML.DocumentEntities.Base;
using yEd.XGML.IO;
using yEd.XGML.DocumentEntities.NodeEntitie;
using yEd.XGML.DocumentEntities.EdgeEntitie;
using yEd.XGML.DocumentEntities.GroupNodeEntitie;

namespace yEd.XGML.DocumentEntities
{
    public class Document
    {
        public string Creator { set; get; } = "yFiles";
        public string Version { set; get; } = "2.14";


        public int hierarchic => 1;
        public string label => "";
        public int directed => 1;


        public Dictionary<int, IElement> Elements { private set; get; } = new Dictionary<int, IElement>();
        
        public IDictionary<int, Node> Nodes => Elements.Values
            .OfType<Node>()
            .ToDictionary(e => e.id);
        public IDictionary<int, GroupNode> GroupNode => Elements.Values
            .OfType<GroupNode>()
            .ToDictionary(e=> e.id);
        /// <summary>
        /// Наибольший из имеющихся ID
        /// </summary>
        public int GetMaxNodeID => Elements.Keys.Max();

        public List<Edge> Edges { private set; get; } = new List<Edge>();



        public static Document Load(string file)
        {
            XGML_Reader.DropEncodingAttribute(file);
            return new XGML_Reader().Read(file);
        }

        public void SaveAs(string file)
        {
            new XGML_Writer().Write(this, file);
        }
    }
}
