﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;
using System.Drawing;

using yEd.XGML.DocumentEntities.NodeEntitie;
using yEd.XGML.Enums;

namespace yEd.XGML.IO.Read
{
    internal class NodeReader : IReader<Node>
    {
        public Node Read(XElement element)
        {
            Node res = new Node();

            res.id = int.Parse(element.GetChild_Attribute("id").Value);
            res.label = element.GetChild_Attribute("label").Value;


            res.graphics = ReadGraphics(element.GetChild_Section("graphics"));
            res.LabelGraphics = ReadLabelGraphics(element.GetChild_Section("LabelGraphics"));


            var gid_attrib = element.GetChild_Attribute("gid");
            if (gid_attrib != null)
                res.gid = int.Parse(gid_attrib.Value);                       


            return res;
        }

        private NodeGraphics ReadGraphics(XElement graphics)
        {
            NodeGraphics res = new NodeGraphics();

            res.x = double.Parse(graphics.GetChild_Attribute("x").Value);
            res.y = double.Parse(graphics.GetChild_Attribute("y").Value);
            res.w = double.Parse(graphics.GetChild_Attribute("w").Value);
            res.h = double.Parse(graphics.GetChild_Attribute("h").Value);
            res.type = (EnumNodeType)Enum.Parse(typeof(EnumNodeType), graphics.GetChild_Attribute("type").Value);
            res.raisedBorder = bool.Parse(graphics.GetChild_Attribute("raisedBorder").Value);
            res.fill = ColorTranslator.FromHtml(graphics.GetChild_Attribute("fill").Value);
            res.outline = ColorTranslator.FromHtml(graphics.GetChild_Attribute("outline").Value);

            return res;
        }

        private NodeLabelGraphics ReadLabelGraphics(XElement LabelGraphics)
        {
            NodeLabelGraphics res = new NodeLabelGraphics();

            res.fontSize = int.Parse(LabelGraphics.GetChild_Attribute("fontSize").Value);
            res.fontName = (EnumFont)Enum.Parse(typeof(EnumFont), LabelGraphics.GetChild_Attribute("fontName").Value);

            return res;
        }

    }
}
