﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;

using yEd.XGML.IO.Write.Tools;
using yEd.XGML.DocumentEntities.EdgeEntitie;

namespace yEd.XGML.IO.Write
{
    internal class EdgeWriter : IWriter<Edge>
    {
        public XElement Write(Edge elem)
        {
            XElement res = XElement_Tools.CreateSection("edge");

            res.Add(XElement_Tools.CreateAttribute("source", "int", elem.source));
            res.Add(XElement_Tools.CreateAttribute("target", "int", elem.target));
            if (elem.label != null)
                res.Add(XElement_Tools.CreateAttribute("label", "String", elem.label));


            res.Add(WriteGraphics(elem.Graphics));
            if (elem.label != null)
                WriteLabelGraphics(elem);


            return res;
        }

        private XElement WriteGraphics(EdgeGraphics graphics)
        {
            XElement res = XElement_Tools.CreateSection("graphics");

            res.Add(XElement_Tools.CreateAttribute("fill", "String", Color_Tools.ColorToHex(graphics.fill)));
            res.Add(XElement_Tools.CreateAttribute("targetArrow", "String", graphics.targetArrow));

            return res;
        }
        private XElement WriteLabelGraphics(Edge elem)
        {
            XElement LabelGraphics = XElement_Tools.CreateSection("LabelGraphics");

            LabelGraphics.Add(XElement_Tools.CreateAttribute("text", "String", elem.label));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("fontSize", "int", elem.LabelGraphics.fontSize.ToString()));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("fontName", "String", elem.LabelGraphics.fontName));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("configuration", "String", elem.LabelGraphics.configuration));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("contentWidth", "String", elem.LabelGraphics.contentWidth));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("contentHeight", "String", elem.LabelGraphics.contentHeight));
            LabelGraphics.Add(new XElement("attribute", new XAttribute("key", "model")));
            LabelGraphics.Add(new XElement("attribute", new XAttribute("key", "position")));

            return LabelGraphics;
        }

    }
}
