﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Xml.Linq;

using yEd.XGML.IO.Write.Tools;
using yEd.XGML.DocumentEntities.GroupNodeEntitie;

namespace yEd.XGML.IO.Write
{
    internal class GroupNodeWriter : IWriter<GroupNode>
    {
        public XElement Write(GroupNode elem)
        {
            var res = XElement_Tools.CreateSection("node");

            res.Add(XElement_Tools.CreateAttribute("id", "int", elem.id.ToString()));
            res.Add(XElement_Tools.CreateAttribute("label", "String", elem.label));


            res.Add(WriteGraphics(elem.graphics));
            res.Add(WriteLabelGraphics(elem));

            res.Add(XElement_Tools.CreateAttribute("isGroup", "boolean", elem.isGroup.ToString().ToLower()));
            if (elem.gid.HasValue)
                res.Add(XElement_Tools.CreateAttribute("gid", "int", elem.gid));

            return res;
        }

        private XElement WriteGraphics(GroupsNodeGraphics GroupsNodeGraphics)
        {
            XElement graphics = XElement_Tools.CreateSection("graphics");

            graphics.Add(XElement_Tools.CreateAttribute("x", "double", GroupsNodeGraphics.x));
            graphics.Add(XElement_Tools.CreateAttribute("y", "double", GroupsNodeGraphics.y));
            graphics.Add(XElement_Tools.CreateAttribute("w", "double", GroupsNodeGraphics.w));
            graphics.Add(XElement_Tools.CreateAttribute("h", "double", GroupsNodeGraphics.h));
            graphics.Add(XElement_Tools.CreateAttribute("type", "String", GroupsNodeGraphics.type));
            graphics.Add(XElement_Tools.CreateAttribute("fill", "String", Color_Tools.ColorToHex(GroupsNodeGraphics.fill)));
            graphics.Add(XElement_Tools.CreateAttribute("outline", "String", Color_Tools.ColorToHex(GroupsNodeGraphics.outline)));
            graphics.Add(XElement_Tools.CreateAttribute("topBorderInset", "double", GroupsNodeGraphics.topBorderInset));
            graphics.Add(XElement_Tools.CreateAttribute("bottomBorderInset", "double", GroupsNodeGraphics.bottomBorderInset));
            graphics.Add(XElement_Tools.CreateAttribute("leftBorderInset", "double", GroupsNodeGraphics.leftBorderInset));
            graphics.Add(XElement_Tools.CreateAttribute("rightBorderInset", "double", GroupsNodeGraphics.rightBorderInset));

            return graphics;
        }
        private XElement WriteLabelGraphics(GroupNode groupNode)
        {
            XElement LabelGraphics = XElement_Tools.CreateSection("LabelGraphics");

            LabelGraphics.Add(XElement_Tools.CreateAttribute("text", "String", groupNode.label));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("fill", "String", Color_Tools.ColorToHex(groupNode.LabelGraphics.fill)));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("fontSize", "int", groupNode.LabelGraphics.fontSize.ToString()));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("fontName", "String", groupNode.LabelGraphics.fontName));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("alignment", "String", groupNode.LabelGraphics.alignment));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("autoSizePolicy", "String", groupNode.LabelGraphics.autoSizePolicy));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("anchor", "String", groupNode.LabelGraphics.anchor));
            LabelGraphics.Add(XElement_Tools.CreateAttribute("borderDistance", "double", groupNode.LabelGraphics.borderDistance));

            return LabelGraphics;
        }

    }
}
