﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Graph.Simple.Entities.Base;
using Graph.Simple.Enums;

namespace Graph.Simple.Entities
{
    /// <summary>
    /// Узел графа 
    /// </summary>
    public class Node : BaseGraphUnit
    {
        #region

        //Позиция вершины
        //public Point2D Position { set; get; }


        //Списки ребер в которых задействова данный узел
        protected List<Edge> _Inputs { set; get; }
        protected List<Edge> _Outputs { set; get; }


        public IReadOnlyList<Edge> Inputs => _Inputs;
        public IReadOnlyList<Edge> Outputs => _Outputs;

        #endregion

        protected Node(int ID, Graph graph) : base(ElementType.Node, graph, ID)
        {
            _Inputs = new List<Edge>();
            _Outputs = new List<Edge>();
        }

    }
}

