﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Xml.Serialization;

namespace TryParseWeb
{
    [Serializable]
    public class Form1Model
    {
        [XmlIgnore]
        public int ScroolDeep { set; get; } = 10;

        [XmlIgnore]
        public int FirstLoadDelay_mlsec { private set; get; } = 3000;
        [XmlIgnore]
        public int FirstLoadDelay_sec
        {
            set { FirstLoadDelay_mlsec = value * 1000; }
            get { return FirstLoadDelay_mlsec/1000; }
        }

        [XmlIgnore]
        public int ScrollDelay_mlsec { private set; get; } = 3000;
        [XmlIgnore]
        public int ScrollDelay_sec
        {
            set { ScrollDelay_mlsec = value * 1000; }
            get { return ScrollDelay_mlsec / 1000; }
        }


        public string URL { set; get; }
        public List<string> Resul { private set; get; } = new List<string>();


        public List<string> SaveResult(string HTML_Body)
        {
            Resul.Clear();            

            for (int i = HTML_Body.IndexOf("TweetTextSize"); i != -1; i = i = HTML_Body.IndexOf("TweetTextSize", i + 1))
            {
                StringBuilder res = new StringBuilder();

                for (; HTML_Body[i] != '<' && i < HTML_Body.Length; i++)
                {
                    res.Append(HTML_Body[i]);
                }

                var split = res.ToString().Trim().Split('>');
                res.Clear();
                for (int j = 1; j < split.Length; j++)
                {
                    res.Append(split[j]);
                }

                Resul.Add(res.ToString());
            }

            return Resul;
        }

        public void ExportText(string FileName)
        {
            using (FileStream fs = new FileStream(FileName, FileMode.Create))
            {
                using (StreamWriter sw = new StreamWriter(fs))
                {
                    sw.WriteLine("URL\n" + URL);

                    for (int i = 0; i < Resul.Count; i++)
                    {
                        var elem = Resul[i];
                        sw.WriteLine("[" + i + "]\n" + elem);
                    }
                }
            }
        }
        public void ExportXML(string FileName)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(Form1Model));

            using (FileStream fs = new FileStream(FileName, FileMode.Create))
            {
                serializer.Serialize(fs, this);
            }
        }

    }
}
