﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Threading;

namespace TryParseWeb
{
    public partial class Form1 : Form
    {
        private Form1Model model = new Form1Model();

        public Form1()
        {
            InitializeComponent();

            textBox_ScrollDepp.Text = model.ScroolDeep.ToString();
            textBox_FirstLoadDelay.Text = model.FirstLoadDelay_sec.ToString();
            textBox_ScrollDelay.Text = model.ScrollDelay_sec.ToString();
        }


        //async void Work()
        //{



        //    var scroll = await Delay(7000, 50000);
        //    webBrowser1.Document.Window.ScrollTo(0, scroll);
        //    scroll = await Delay(15000, 0);
        //    var res = Find(webBrowser1.Document, scroll);
        //}


        private Task<int> Delay(int delay, int res)
        {
            return Task.Run(() =>
            {
                Thread.Sleep(delay);
                return res;
            });
        }


        private async void button_Start_Click(object sender, EventArgs e)
        {
            button_Settings_Click(sender, e);

            button_Start.Enabled = false;
            //button_Settings.Enabled = false;
            button_SaveText.Enabled = false;
            button_SaveXML.Enabled = false;

            textBox_ScrollDepp.Enabled = false;
            textBox_FirstLoadDelay.Enabled = false;
            textBox_ScrollDelay.Enabled = false;

            try
            {
                model.URL = textBox_URL.Text;
                webBrowser1.Url = new Uri(model.URL);

                await Delay(model.FirstLoadDelay_mlsec, model.ScrollDelay_mlsec);

                for (int i = 0; i < model.ScroolDeep; i++)
                {
                    label_Progress.Text = (i+1) + " из " + model.ScroolDeep;

                    webBrowser1.Document.Window.ScrollTo(0, webBrowser1.Document.Body.ScrollRectangle.Height);
                    await Delay(model.ScrollDelay_mlsec, model.ScrollDelay_mlsec);                    
                }

                var res = model.SaveResult(
                    webBrowser1.Document.Body.InnerHtml);

                label_Result.Text = "Обнаружено: " + res.Count + " Записей";
            }
            catch (Exception ex)
            {
                MessageBox.Show("Ошибка: " + ex.Message);
            }


            button_Start.Enabled = true;
            //button_Settings.Enabled = true;
            button_SaveText.Enabled = true;
            button_SaveXML.Enabled = true;

            textBox_ScrollDepp.Enabled = true;
            textBox_FirstLoadDelay.Enabled = true;
            textBox_ScrollDelay.Enabled = true;
        }

        private void button_Settings_Click(object sender, EventArgs e)
        {
            try
            {
                model.ScroolDeep = int.Parse(textBox_ScrollDepp.Text);
                model.FirstLoadDelay_sec = int.Parse(textBox_FirstLoadDelay.Text);
                model.ScrollDelay_sec = int.Parse(textBox_ScrollDelay.Text);
            }
            catch (Exception ex)
            {
                textBox_ScrollDepp.Text = model.ScroolDeep.ToString();
                textBox_FirstLoadDelay.Text = model.FirstLoadDelay_sec.ToString();
                textBox_ScrollDelay.Text = model.ScrollDelay_sec.ToString();
            }
        }

        private void button_SaveText_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.Cancel)
                return;

            model.ExportText(saveFileDialog1.FileName);
        }

        private void button_SaveXML_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.Cancel)
                return;

            model.ExportXML(saveFileDialog1.FileName);
        }

    }
}

