

class TableRow {

  constructor( ) {
    this.index = -1;
	this.url = "";
	this.title = "";
	this.id = -1;
	this.checked = false;
  }
}
  
  
  var Div_TableBody; 
  var Inp_SaveLoad;
  
 document.addEventListener("DOMContentLoaded", function(event) { 
	console.log('Start');
	console.log(Data = new Date().toTimeString());


	Div_TableBody = document.getElementById('Table');
	Inp_SaveLoad = document.getElementById('SaveLoad');
	
	chrome.tabs.query({}, PrintAllTabs);
	
	
	document.getElementById('Button_Reload').addEventListener('click', LoadTabs, false);	
	document.getElementById('Button_Save').addEventListener('click', SaveSelect, false);
	document.getElementById('Button_Close').addEventListener('click', CloseSelect, false);
	document.getElementById('Button_Load').addEventListener('click', Load, false);

});


function LoadTabs()
{	
	chrome.tabs.query({}, PrintAllTabs);
}


function PrintAllTabs(tabs)
{
	Div_TableBody.innerHTML = "";
	
	var Table='';
	
	Table += "<table id = \"table_data\" border=\"1\">"
	
	
	Table += "<tr>"
	
	Table += "<th>N</th>"
	Table += "<th>Select</th>"
	Table += "<th>Title</th>"
	Table += "<th>Url</th>"
	Table += "<th style=\"display:none;\">id</th>"
	
	Table += "</tr>"	

	
	tabs.forEach(function(item, i, arr) {
		
		Table += "<tr>"		
		
		Table += "<td>"+i+"</td>"	
		Table += "<td><input type=\"checkbox\" name=\"select" + item.id + " \"></td>"
		Table += "<td>"+item.title+"</td>"
		Table += "<td>"+item.url+"</td>" //.substring(0,10)
		Table += "<td style=\"display:none;\">"+item.id+"</td>"		
		
		Table += "</tr>"
		
	});		
	
	Table += "</table>"
		
	Div_TableBody.innerHTML = Table;
}


function GetSelectedRows()
{
	var SelectedRow = [];	
	
	var table = document.getElementById('table_data');	
	
	for (var i = 1, row; row = table.rows[i]; i++) 
	{
		var RowObj = new TableRow();
		
		for (var j = 0, col; col = row.cells[j]; j++) 
		{
			var cell = col.childNodes[0];
			
			switch (j) {
			case 0:
				RowObj.index = cell.data;
				break;
			case 1:
				RowObj.checked = cell.checked;				
				break;
			case 2:
				RowObj.title = cell.data;				
				break;
			case 3:
				RowObj.url = cell.data;				
				break;
			case 4:
				RowObj.id = cell.data;			
				break
			}
		}

		if (RowObj.checked)
			SelectedRow.push(RowObj);
	}
	
	return SelectedRow;
}

function Load()
{
	var data = JSON.parse(Inp_SaveLoad.value);
	
	var RowData = [];
	
	data.forEach(function(item, i, arr)
	{
		var RowObj = new TableRow();
		//RowObj.index = item.index;
		RowObj.url = item.url;
		//RowObj.id = item.id;
	
		RowData.push(RowObj);
	});
	
	RowData.forEach(function(item, i, arr)
	{
		chrome.tabs.create({"url":item.url}, null)
	});
}
function SaveSelect()
{
	Inp_SaveLoad.value = "";
	console.log("TrySave");		
	
	var SelectedRow = GetSelectedRows();
	
	if (SelectedRow.length == 0)
	{
		Inp_SaveLoad.value = "No rows selected";	
		return;
	}
	
	Inp_SaveLoad.value = JSON.stringify(SelectedRow);
	
	var type = 'data:application/octet-stream;base64, ';
	var text = Inp_SaveLoad.value;
	var base = btoa(text);
	var res = type + base;
	document.getElementById('FileUpload').href = res;
}
function CloseSelect()
{
	Inp_SaveLoad.value = "";
	console.log("TryClose");
	
	var SelectedRow = GetSelectedRows();
	
	if (SelectedRow.length == 0)
	{
		Inp_SaveLoad.value = "No rows selected";
		return;
	}
	
	var IDs = [];
	
	SelectedRow.forEach(function(item, i, arr)
	{
		IDs.push(parseInt(item.id));
	});
	
	Div_TableBody.innerHTML = "";
		
	chrome.tabs.remove(IDs, function(){
		chrome.tabs.query({}, PrintAllTabs)
	});
	
	//console.log(Data = new Date().toTimeString());
	//setTimeout(null, 3000);	
	//console.log(Data = new Date().toTimeString());
	
}


