using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

using Newtonsoft.Json.Linq;

using Learn_CSS.DI;

using Learn_CSS.Model.Entities;

using Learn_CSS.Model.DAL;

using Learn_CSS.APP.Web.Models.ModelBinders;

namespace Learn_CSS.APP.Web
{
    public class MvcApplication 
        : System.Web.HttpApplication
    {
        protected void Application_Start()
        {
            DiRegistry.SetupRegistry(
                Server.MapPath("~/AppData")
                );

            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);

            RegisterModelBinders();
            RegisterTaskStorage();
        }

        private void RegisterModelBinders() 
        {
            ModelBinders.Binders.Add(typeof(JObject), new JsonModelBinder());
            ModelBinders.Binders.Add(typeof(ValidateEntity), new ValidateEntityBinder());
        }

        private void RegisterTaskStorage() 
        {
            var taskStorage = DiRegistry.Resolve<CSSTaskStorage>();

            taskStorage.Load();
            taskStorage.Save();           
        }

    }
}
