﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Learn_CSS.APP.Web.Models.Tools
{
    public class ElementWithPositionEntity<T>
    {
        public T Element { set; get; }
        public int Index { set; get; }
    }


    public static class ListExtensions
    {

        /// <summary>
        /// Поиск элемента с сохранением позиции
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="list"></param>
        /// <param name="predicate"></param>
        /// <returns>Сущность обертку или null</returns>
        public static ElementWithPositionEntity<T> FirstOrDefaultWithPosition<T>(this IList<T> list, Func<T, bool> predicate)
        {
            for (int i = 0; i < list.Count; i++)
            {
                var elem = list[i];

                if (predicate(elem))
                {
                    return new ElementWithPositionEntity<T>()
                    {
                        Element = elem,
                        Index = i
                    };
                }
            }

            return null;
        }
    }
}