﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Microsoft.Extensions.DependencyInjection;


using Learn_CSS.Model.DAL;
using Learn_CSS.Model.DAL.Serialization;

using Learn_SQL.Model.DAL;


using Learn_CSS.Model.BLL;

using Learn_SQL.Model.BLL;

namespace Learn_CSS.DI
{
    public static class DiRegistry
    {
        public static IServiceProvider ServiceLocator { private set; get; }
        public static T Resolve<T>()
            => ServiceLocator.GetService<T>();

        public static string AppPath { private set; get; }

        public static void SetupRegistry(string appPath)
        {
            AppPath = appPath;

            ServiceCollection services = new ServiceCollection();

            RegistryDAL(services);
            RegistryBLL(services);

            RegistryDAL_SQL(services);
            RegistryBLL_SQL(services);

            ServiceLocator = services.BuildServiceProvider();
        }


        private static void RegistryDAL(IServiceCollection services) 
        {
            services
                .AddSingleton<TaskSerializerService>()
                .AddSingleton<CSSTaskStorage>(
                    e => new CSSTaskStorage(AppPath, Resolve<TaskSerializerService>())
                );
        }

        private static void RegistryDAL_SQL(IServiceCollection services)
        {
            services
                .AddSingleton<ISqlTaskStorage, FakeStorage>()
                .AddSingleton<IDbExecuter, DbExecute>(
                    e => new DbExecute(
                        @"Server = 127.0.0.1; Database = Vsevolod; User Id = Vsevolod; Password = qHuYlX;"
)
                );
        }


        private static void RegistryBLL(IServiceCollection services) 
        {
            services
                .AddSingleton<JsonIncludeService>()
                .AddSingleton<TaskService>();
        }
        private static void RegistryBLL_SQL(IServiceCollection services)
        {
            services
                .AddSingleton<SqlTester>();
        }

    }
}
