﻿
class TaskMenuControl {

    //clickFunction(TaskID)
    constructor(clickFunction) {
        this.api = new ApiProvider();

        this.TaskMenu = document.getElementById('TaskMenu');
        this.ClickFunction = clickFunction;

        this.LoadMenu();
    }


    LoadMenu() {

        let menu_line_template = '<li><a id="{0}" href="#">{1}</a></li>';
        let button_name_template = 'TaskButton{0}';
        let button_text_template = 'Task {0}';

        this.api.Count()
            .then(e =>
            {
                let menu_html = "";

                for (let i = 0; i < e; i++) {
                    menu_html += menu_line_template.format(button_name_template.format(i), button_text_template.format(i+1));
                }

                this.TaskMenu.innerHTML = menu_html;

                for (let i = 0; i < e; i++) {
                    document.getElementById(button_name_template.format(i))
                        .onclick = () => {
                            this.ClickFunction(i);
                        };
                }
            });
    }

}