using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Microsoft.OpenApi.Models;
using Microsoft.AspNetCore.Mvc.NewtonsoftJson;

using Newtonsoft.Json;

using Tools.PdfProvider;

using LibraryText;
using LibraryText.Entities;

using Calibre.Model.Database;
using Calibre.Model.Database.Entities;
using Calibre.Model.Domain.Entities;
using Calibre.Model.Domain.Dal;

namespace Calibre.WebApi
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            //mvc controller
            services
                .AddControllers()
                .AddNewtonsoftJson(
                    e => 
                    {
                        e.SerializerSettings.ReferenceLoopHandling 
                            = ReferenceLoopHandling.Ignore;
                    }
                );

            //swaggerp
            services.AddSwaggerGen(c =>
            {
                c.SwaggerDoc("v1", new OpenApiInfo { Title = "Calibre.WebApi", Version = "v1" });
            });


            services.AddSingleton<SearchProvider>();
            services.AddSingleton<SimplePdfReader>();
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
                app.UseSwagger();
                app.UseSwaggerUI(c => c.SwaggerEndpoint("/swagger/v1/swagger.json", "Calibre.WebApi v1"));
            }

            app.UseRouting();

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }
    }
}
