﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Windows.Forms;

using RW_Tool.XML_BIN;

using Tools.ConfigurationTool.Services;

namespace Tools.ConfigurationTool.Config
{    
    //Базовые параметры конфига
    public class ConfigParams
    {
        //Типо DI
        public RW_Factory RW_Factory => new RW_Factory();

        /// <summary>
        /// Имя или полный путь к файлу конфигурации
        /// </summary>
        public string ConfigFile { set; get; }

        /// <summary>
        /// Флаг: испоьзовать ли в пути к файлу путь к .exe приложению
        /// </summary>
        public bool UseApplicationPathPrefix { set; get; } = true;

        /// <summary>
        /// Формат в котором будет храниться конфиг
        /// </summary>
        public EnumFormat Format { set; get; } = EnumFormat.XML;


        /// <summary>
        /// Полный путь по которому выполняются обращению к конфигу
        /// </summary>
        public string ConfigPath => (UseApplicationPathPrefix
            ?
             Path.Combine(Application.StartupPath, ConfigFile)
            :
             ConfigFile
            );


        public ConfigParams(string ConfigFile)
        {
            this.ConfigFile = ConfigFile;
        }
    }

}
