﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tools.SingletonTool
{
    /// <summary>
    /// Обычный Singleton
    /// </summary>
    /// <typeparam name="T">
    /// Объект T будет существовать в единственном экземпляре
    /// </typeparam>
    public static class Signlethon<T> 
        where T: class, new()
    {
        //Экземпляр синглтон
        private static T single;

        //Создан ли экземпляр
        public static bool ExistInstance => single != null;


        //Метод доступа к синглтону
        public static T Get()
        {
            if (single == null)
                single = new T();

            return single;
        }
        
    }
}
