﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using RW_Tool.Core.Abstract;

namespace RW_Tool.Core
{
    /// <summary>
    /// Обертка для чтения/записи какой либо сущности в какое либо хранилище
    /// </summary>
    /// <typeparam name="T1">Сущность</typeparam>
    /// <typeparam name="T2">Набор параметров</typeparam>
    public class RW_Service<T1,T2> :
        I_RW_Service<T1, T2>
    {
        public T2 DataStorage { protected set; get; }
        public bool HaveDataStorage => DataStorage != null;

        public readonly IReader<T1, T2> Reader;
        public bool HaveReader => Reader != null;

        public readonly IWriter<T1, T2> Writer;
        public bool HaveWriter => Writer != null;


        public RW_Service(
            IReader<T1, T2> Reader,
            IWriter<T1, T2> Writer
            )
        {
            this.Reader = Reader;
            this.Writer = Writer;
        }
        public RW_Service(
            T2 ds, 
            IReader<T1, T2> Reader, 
            IWriter<T1, T2> Writer
            )
        {
            this.DataStorage = ds;
            this.Reader = Reader;
            this.Writer = Writer;
        }


        public T1 Read(T2 param)
        {
            if (!HaveReader)
                throw new Exception();            

            return Reader.Read(param);
        }
        public T1 Read() => Read(DataStorage);

        public void Write(T1 entity, T2 param)
        {
            if (!HaveWriter)
                throw new Exception();

            Writer.Write(entity, param);
        }
        public void Write(T1 entity) => Write(entity, DataStorage);

    }


}
