﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Tools.SingletonTool.Base
{

    /// <summary>
    /// Обертка над статичным классом
    /// </summary>
    /// <typeparam name="T">Тип синглтон</typeparam>
    public interface ISignlethonManager<T>
        where T : class, new()
    {
        /// <summary>
        /// Получить экземпляр
        /// </summary>
        T Get { get; }

        /// <summary>
        /// Создан ли экземпляр
        /// </summary>
        bool ExistInstance { get; }
    }
}
