﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;
using System.Collections.Concurrent;
using System.Collections.Specialized;
using System.Collections.ObjectModel;

namespace Tools.Collections.Concurrent.AsyncBuffer.Store
{

    public interface IConcurrentStore<T>
    {
        int Size { get; }

        int Add(T data);
        bool TryTake(out T data);

        IEnumerable<T> AsIEnumerable();
        void ForEach(Action<T> action);


        /// <summary>
        /// В хранилище добавлен новый элемент.
        /// </summary>
        event Action<IConcurrentStore<T>, T> OnItemAdded;

        /// <summary>
        /// Хранилище опустело.
        /// </summary>
        event Action<IConcurrentStore<T>> OnEmpty;

    }
    
}
