﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.ComponentModel;
using System.Reflection;

namespace WinForm_And_Data.Data.DataEntity
{
    public class MyBindingList<T> : BindingList<T>
    {
        //http://www.cyberforum.ru/windows-forms/thread390432.html
        //Пример списка с сортировкой для DataGridView
        public MyBindingList(IList<T> spisok)
            : base(spisok)
        {
            SortPropertyNumber = 0;
        }


        //Метод сортировки
        protected override void ApplySortCore(PropertyDescriptor prop, ListSortDirection direction)
        {
            var list = this.Items;
            var templist = new List<T>();
            if (direction == ListSortDirection.Ascending)
                templist = list.OrderBy(y => prop.GetValue(y)).ToList();
            else
                templist = list.OrderByDescending(y => prop.GetValue(y)).ToList();
            list.Clear();
            foreach (var inside in templist)
            {
                list.Add(inside);
            }
        }

        public int SortPropertyNumber { set; get; }
        //Флаг поддержкт возможности сортировки
        protected override bool SupportsSortingCore
        {
            get { return true; }
        }
    }
}
